/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.api.util.Log;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.GetArtifactoryServerExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.CreateBuildDataFileCallable;
import org.jfrog.hudson.pipeline.declarative.utils.ReadBuildDataFileCallable;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ExtractorUtils;

public class DeclarativePipelineUtils {
    static final String PIPELINE_CACHE_DIR_NAME = "artifactory-pipeline-cache";

    public static void writeBuildDataFile(FilePath ws, String buildNumber, BuildDataFile buildDataFile, Log logger) throws Exception {
        ExtractorUtils.createAndGetTempDir(ws).act((FilePath.FileCallable)new CreateBuildDataFileCallable(buildNumber, buildDataFile, logger));
    }

    public static BuildDataFile readBuildDataFile(FilePath ws, String buildNumber, String stepName, String stepId) throws IOException, InterruptedException {
        return (BuildDataFile)ExtractorUtils.createAndGetTempDir(ws).act((FilePath.FileCallable)new ReadBuildDataFileCallable(buildNumber, stepName, stepId));
    }

    static String getBuildDataFileName(String stepName, String stepId) {
        return stepName + "_" + Base64.encodeBase64URLSafeString((byte[])stepId.getBytes());
    }

    public static ArtifactoryServer getArtifactoryServer(Run build, FilePath ws, StepContext context, String serverId) throws IOException, InterruptedException {
        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(ws, buildNumber, "rtServer", serverId);
        if (buildDataFile == null) {
            GetArtifactoryServerExecutor getArtifactoryServerExecutor = new GetArtifactoryServerExecutor(build, context, serverId);
            getArtifactoryServerExecutor.execute();
            return getArtifactoryServerExecutor.getArtifactoryServer();
        }
        JsonNode jsonNode = buildDataFile.get("rtServer");
        ArtifactoryServer server = (ArtifactoryServer)Utils.mapper().treeToValue((TreeNode)jsonNode, ArtifactoryServer.class);
        String credentialsId = jsonNode.get("credentialsId").asText();
        if (!credentialsId.isEmpty()) {
            server.setCredentialsId(credentialsId);
        } else {
            server.setUsername(jsonNode.get("username").asText());
            server.setPassword(jsonNode.get("password").asText());
        }
        return server;
    }

    public static String createBuildInfoId(Run build, String customBuildName, String customBuildNumber) {
        return StringUtils.defaultIfEmpty((String)customBuildName, (String)BuildUniqueIdentifierHelper.getBuildName(build)) + "_" + StringUtils.defaultIfEmpty((String)customBuildNumber, (String)BuildUniqueIdentifierHelper.getBuildNumber(build));
    }

    public static BuildInfo getBuildInfo(FilePath ws, Run build, String customBuildName, String customBuildNumber) throws IOException, InterruptedException {
        String buildInfoId;
        String jobBuildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(ws, jobBuildNumber, "rtBuildInfo", buildInfoId = DeclarativePipelineUtils.createBuildInfoId(build, customBuildName, customBuildNumber));
        if (buildDataFile == null) {
            BuildInfo buildInfo = new BuildInfo(build);
            if (StringUtils.isNotBlank((String)customBuildName)) {
                buildInfo.setName(customBuildName);
            }
            if (StringUtils.isNotBlank((String)customBuildNumber)) {
                buildInfo.setNumber(customBuildNumber);
            }
            return buildInfo;
        }
        return (BuildInfo)Utils.mapper().treeToValue((TreeNode)buildDataFile.get("rtBuildInfo"), BuildInfo.class);
    }

    public static void saveBuildInfo(BuildInfo buildInfo, FilePath ws, Run build, Log logger) throws Exception {
        String jobBuildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        String buildInfoId = DeclarativePipelineUtils.createBuildInfoId(build, buildInfo.getName(), buildInfo.getNumber());
        BuildDataFile buildDataFile = new BuildDataFile("rtBuildInfo", buildInfoId);
        buildDataFile.putPOJO(buildInfo);
        DeclarativePipelineUtils.writeBuildDataFile(ws, jobBuildNumber, buildDataFile, logger);
    }

    static void deleteOldBuildDataDirs(File tmpDir, Log logger) {
        if (!tmpDir.exists()) {
            return;
        }
        File[] buildDataDirs = tmpDir.listFiles(buildDataDir -> {
            long ageInMilliseconds = new Date().getTime() - buildDataDir.lastModified();
            return ageInMilliseconds > TimeUnit.DAYS.toMillis(1L);
        });
        if (buildDataDirs == null) {
            logger.error("Failed while attempting to delete old build data dirs. Could not list files in " + tmpDir);
            return;
        }
        for (File buildDataDir2 : buildDataDirs) {
            try {
                FileUtils.deleteDirectory((File)buildDataDir2);
                logger.debug(buildDataDir2.getAbsolutePath() + " deleted");
            }
            catch (IOException e) {
                logger.error("Failed while attempting to delete old build data dir: " + buildDataDir2.toString(), (Throwable)e);
            }
        }
    }
}

