/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.maven;

import hudson.Extension;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jfrog.hudson.pipeline.common.types.deployers.MavenDeployer;
import org.jfrog.hudson.pipeline.declarative.steps.maven.MavenDeployerResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MavenDeployerStep
extends MavenDeployerResolver {
    static final String STEP_NAME = "rtMavenDeployer";
    private MavenDeployer mavenDeployer = new MavenDeployer();

    @DataBoundConstructor
    public MavenDeployerStep(String id, String releaseRepo, String snapshotRepo, String serverId) {
        super(STEP_NAME, id, serverId);
        this.mavenDeployer.setReleaseRepo(releaseRepo).setSnapshotRepo(snapshotRepo);
        this.buildDataFile.putPOJO(this.mavenDeployer);
    }

    @DataBoundSetter
    public void setIncludePatterns(List<String> includePatterns) {
        includePatterns.forEach(pattern -> this.mavenDeployer.getArtifactDeploymentPatterns().addInclude((String)pattern));
    }

    @DataBoundSetter
    public void setExcludePatterns(List<String> excludePatterns) {
        excludePatterns.forEach(pattern -> this.mavenDeployer.getArtifactDeploymentPatterns().addExclude((String)pattern));
    }

    @DataBoundSetter
    public void setIncludeEnvVars(boolean includeEnvVars) {
        this.mavenDeployer.setIncludeEnvVars(includeEnvVars);
    }

    @DataBoundSetter
    public void setCustomBuildName(String customBuildName) {
        this.mavenDeployer.setCustomBuildName(customBuildName);
    }

    @DataBoundSetter
    public void setProperties(List<String> properties) {
        this.buildDataFile.put("properties", String.join((CharSequence)";", properties));
    }

    @DataBoundSetter
    public void setDeployArtifacts(boolean deployArtifacts) {
        this.mavenDeployer.setDeployArtifacts(deployArtifacts);
    }

    @DataBoundSetter
    public void setDeployEvenIfUnstable(boolean deployEvenIfUnstable) {
        this.mavenDeployer.setDeployEvenIfUnstable(deployEvenIfUnstable);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(MavenDeployerResolver.Execution.class);
        }

        public String getFunctionName() {
            return MavenDeployerStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "set maven deployer";
        }

        public boolean isAdvanced() {
            return true;
        }
    }
}

