/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.gradle;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.GradleExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.GradleDeployer;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.GradleBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.GradleResolver;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.PropertyUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GradleStep
extends AbstractStepImpl {
    private GradleBuild gradleBuild = new GradleBuild();
    private String customBuildNumber;
    private String customBuildName;
    private String deployerId;
    private String resolverId;
    private String buildFile;
    private String switches;
    private String rootDir;
    private String tasks;

    @DataBoundConstructor
    public GradleStep() {
    }

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setDeployerId(String deployerId) {
        this.deployerId = deployerId;
    }

    @DataBoundSetter
    public void setResolverId(String resolverId) {
        this.resolverId = resolverId;
    }

    @DataBoundSetter
    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    @DataBoundSetter
    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    @DataBoundSetter
    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    @DataBoundSetter
    public void setSwitches(String switches) {
        this.switches = switches;
    }

    @DataBoundSetter
    public void setTool(String tool) {
        this.gradleBuild.setTool(tool);
    }

    @DataBoundSetter
    public void setUseWrapper(boolean useWrapper) {
        this.gradleBuild.setUseWrapper(useWrapper);
    }

    @DataBoundSetter
    public void setUsesPlugin(boolean usesPlugin) {
        this.gradleBuild.setUsesPlugin(usesPlugin);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "rtGradleRun";
        }

        public String getDisplayName() {
            return "run Artifactory gradle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient GradleStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;

        protected Void run() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.ws, this.build, this.step.customBuildName, this.step.customBuildNumber);
            this.setGradleBuild();
            GradleExecutor gradleExecutor = new GradleExecutor(this.build, this.step.gradleBuild, this.step.tasks, this.step.buildFile, this.step.rootDir, this.step.switches, buildInfo, this.env, this.ws, this.listener, this.launcher);
            gradleExecutor.execute();
            buildInfo = gradleExecutor.getBuildInfo();
            DeclarativePipelineUtils.saveBuildInfo(buildInfo, this.ws, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        private void setGradleBuild() throws IOException, InterruptedException {
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(this.build);
            this.setDeployer(buildNumber);
            this.setResolver(buildNumber);
        }

        private void setDeployer(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((String)this.step.deployerId)) {
                return;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.ws, buildNumber, "rtGradleDeployer", this.step.deployerId);
            if (buildDataFile == null) {
                throw new IOException("Deployer " + this.step.deployerId + " doesn't exist!");
            }
            GradleDeployer deployer = (GradleDeployer)Utils.mapper().treeToValue((TreeNode)buildDataFile.get("rtGradleDeployer"), GradleDeployer.class);
            deployer.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.gradleBuild.setDeployer(deployer);
            this.addProperties(buildDataFile);
        }

        private void addProperties(BuildDataFile buildDataFile) {
            JsonNode propertiesNode = buildDataFile.get("properties");
            if (propertiesNode != null) {
                this.step.gradleBuild.getDeployer().getProperties().putAll(PropertyUtils.getDeploymentPropertiesMap(propertiesNode.asText(), this.env));
            }
        }

        private void setResolver(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((String)this.step.resolverId)) {
                return;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.ws, buildNumber, "rtGradleResolver", this.step.resolverId);
            if (buildDataFile == null) {
                throw new IOException("Resolver " + this.step.resolverId + " doesn't exist!");
            }
            GradleResolver resolver = (GradleResolver)Utils.mapper().treeToValue((TreeNode)buildDataFile.get("rtGradleResolver"), GradleResolver.class);
            resolver.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.gradleBuild.setResolver(resolver);
        }

        private ArtifactoryServer getArtifactoryServer(String buildNumber, BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.ws, this.getContext(), serverId.asText());
        }
    }
}

