/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.generic;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.executors.GenericDownloadExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.pipeline.declarative.steps.generic.GenericStep;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class DownloadStep
extends GenericStep {
    @DataBoundConstructor
    public DownloadStep(String serverId) {
        super(serverId);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "rtDownload";
        }

        public String getDisplayName() {
            return "Download artifacts";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends GenericStep.Execution {
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        protected Void run() throws Exception {
            this.setGenericParameters(this.listener, this.build, this.ws, this.env, this.step, this.getContext());
            GenericDownloadExecutor genericDownloadExecutor = new GenericDownloadExecutor(this.artifactoryServer, this.listener, this.build, this.ws, this.buildInfo, this.spec, this.step.failNoOp);
            genericDownloadExecutor.execute();
            BuildInfo buildInfo = genericDownloadExecutor.getBuildInfo();
            new BuildInfoAccessor(buildInfo).captureVariables(this.env, this.build, this.listener);
            DeclarativePipelineUtils.saveBuildInfo(buildInfo, this.ws, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }
    }
}

