/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.executors.PublishBuildInfoExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PublishBuildInfoStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtPublishBuildInfo";
    private String buildNumber;
    private String buildName;
    private String serverId;

    @DataBoundConstructor
    public PublishBuildInfoStep(String serverId) {
        this.serverId = serverId;
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return PublishBuildInfoStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Publish build info";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient PublishBuildInfoStep step;

        protected Void run() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.ws, this.build, this.step.buildName, this.step.buildNumber);
            if (buildInfo == null) {
                throw new RuntimeException("Build " + DeclarativePipelineUtils.createBuildInfoId(this.build, this.step.buildName, this.step.buildNumber) + " does not exist!");
            }
            ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.ws, this.getContext(), this.step.serverId);
            new PublishBuildInfoExecutor(this.build, this.listener, buildInfo, server).execute();
            return null;
        }
    }
}

