/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.PromotionExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PromoteBuildStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtPromote";
    protected PromotionConfig promotionConfig;
    protected String serverId;

    @DataBoundConstructor
    public PromoteBuildStep(String serverId, String targetRepo) {
        this.serverId = serverId;
        this.promotionConfig = new PromotionConfig();
        if (StringUtils.isNotBlank((String)targetRepo)) {
            this.promotionConfig.setTargetRepo(targetRepo);
        }
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.promotionConfig.setBuildName(buildName);
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.promotionConfig.setBuildNumber(buildNumber);
    }

    @DataBoundSetter
    public void setSourceRepo(String sourceRepo) {
        this.promotionConfig.setSourceRepo(sourceRepo);
    }

    @DataBoundSetter
    public void setComment(String comment) {
        this.promotionConfig.setComment(comment);
    }

    @DataBoundSetter
    public void setStatus(String status) {
        this.promotionConfig.setStatus(status);
    }

    @DataBoundSetter
    public void setCopy(boolean copy) {
        this.promotionConfig.setCopy(copy);
    }

    @DataBoundSetter
    public void setIncludeDependencies(boolean includeDependencies) {
        this.promotionConfig.setIncludeDependencies(includeDependencies);
    }

    @DataBoundSetter
    public void setFailFast(boolean failFast) {
        this.promotionConfig.setFailFast(failFast);
    }

    PromotionConfig preparePromotionConfig(Run build) {
        if (StringUtils.isBlank((String)this.promotionConfig.getBuildName())) {
            this.promotionConfig.setBuildName(BuildUniqueIdentifierHelper.getBuildName(build));
        }
        if (StringUtils.isBlank((String)this.promotionConfig.getBuildNumber())) {
            this.promotionConfig.setBuildNumber(BuildUniqueIdentifierHelper.getBuildNumber(build));
        }
        return this.promotionConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return PromoteBuildStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Promote build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient PromoteBuildStep step;

        protected Void run() throws Exception {
            PromotionConfig promotionConfig = this.step.preparePromotionConfig(this.build);
            ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.ws, this.getContext(), this.step.serverId);
            new PromotionExecutor(Utils.prepareArtifactoryServer(null, server), this.build, this.listener, this.getContext(), promotionConfig).execute();
            return null;
        }
    }
}

