/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BuildInfoStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtBuildInfo";
    private BuildInfo buildInfo = new BuildInfo();

    @DataBoundConstructor
    public BuildInfoStep() {
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildInfo.setName(buildName);
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.buildInfo.setNumber(buildNumber);
    }

    @DataBoundSetter
    public void setStartDate(Date date) {
        this.buildInfo.setStartDate(date);
    }

    @DataBoundSetter
    public void setCaptureEnv(boolean capture) {
        this.buildInfo.getEnv().setCapture(capture);
    }

    @DataBoundSetter
    public void setIncludeEnvPatterns(List<String> includeEnvPatterns) {
        includeEnvPatterns.forEach(pattern -> this.buildInfo.getEnv().getFilter().addInclude((String)pattern));
    }

    @DataBoundSetter
    public void setExcludeEnvPatterns(List<String> excludeEnvPatterns) {
        excludeEnvPatterns.forEach(pattern -> this.buildInfo.getEnv().getFilter().addExclude((String)pattern));
    }

    @DataBoundSetter
    public void setMaxBuilds(int maxBuilds) {
        this.buildInfo.getRetention().setMaxBuilds(maxBuilds);
    }

    @DataBoundSetter
    public void setAsyncBuildRetention(boolean async) {
        this.buildInfo.getRetention().setAsync(async);
    }

    @DataBoundSetter
    public void setDeleteBuildArtifacts(boolean deleteBuildArtifact) {
        this.buildInfo.getRetention().setDeleteBuildArtifacts(deleteBuildArtifact);
    }

    @DataBoundSetter
    public void setDoNotDiscardBuilds(List<String> buildNumbersNotToBeDiscarded) {
        this.buildInfo.getRetention().setDoNotDiscardBuilds(buildNumbersNotToBeDiscarded);
    }

    @DataBoundSetter
    public void setMaxDays(int days) {
        this.buildInfo.getRetention().setMaxDays(days);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return BuildInfoStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Create build info";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient BuildInfoStep step;

        protected Void run() throws Exception {
            String buildName = StringUtils.isBlank((String)this.step.buildInfo.getName()) ? BuildUniqueIdentifierHelper.getBuildName(this.build) : this.step.buildInfo.getName();
            String buildNumber = StringUtils.isBlank((String)this.step.buildInfo.getNumber()) ? BuildUniqueIdentifierHelper.getBuildNumber(this.build) : this.step.buildInfo.getNumber();
            this.step.buildInfo.setName(buildName);
            this.step.buildInfo.setNumber(buildNumber);
            DeclarativePipelineUtils.saveBuildInfo(this.step.buildInfo, this.ws, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }
    }
}

