/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.packageManagerBuilds;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;

public class PackageManagerBuild
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient CpsScript cpsScript;
    Deployer deployer;
    Resolver resolver;
    String tool = "";

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    @Whitelisted
    public String getTool() {
        return this.tool;
    }

    @Whitelisted
    public void setTool(String tool) {
        this.tool = tool;
    }

    @Whitelisted
    public Deployer getDeployer() {
        return this.deployer;
    }

    @Whitelisted
    public Resolver getResolver() {
        return this.resolver;
    }

    void setResolver(Map<String, Object> resolverArguments, List<String> keysAsList) throws Exception {
        this.checkArguments(resolverArguments, keysAsList);
        this.updateResolverDeployer(resolverArguments, this.resolver);
        Object server = resolverArguments.get("server");
        if (server != null) {
            this.resolver.setServer((ArtifactoryServer)server);
        }
    }

    void setDeployer(Map<String, Object> deployerArguments, List<String> keysAsList) throws Exception {
        this.checkArguments(deployerArguments, keysAsList);
        this.updateResolverDeployer(deployerArguments, this.deployer);
        Object server = deployerArguments.remove("server");
        if (server != null) {
            this.deployer.setServer((ArtifactoryServer)server);
        }
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    private void checkArguments(Map<String, Object> arguments, List<String> keysAsList) {
        Set<String> resolverArgumentsSet = arguments.keySet();
        if (!keysAsList.containsAll(resolverArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
    }

    private void updateResolverDeployer(Map<String, Object> arguments, Object valueToUpdate) throws IOException {
        HashMap<String, Object> serverlessArguments = new HashMap<String, Object>(arguments);
        serverlessArguments.remove("server");
        JSONObject json = new JSONObject();
        json.putAll(serverlessArguments);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readerForUpdating(valueToUpdate).readValue(json.toString());
    }
}

