/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.packageManagerBuilds;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.NpmDeployer;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.NpmResolver;

public class NpmBuild
extends PackageManagerBuild {
    public NpmBuild() {
        this.deployer = new NpmDeployer();
        this.resolver = new NpmResolver();
    }

    @Whitelisted
    public void install(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareNpmStep(args, Arrays.asList("path", "args", "buildInfo"));
        stepVariables.put("args", args.get("args"));
        this.cpsScript.invokeMethod("artifactoryNpmInstall", stepVariables);
    }

    @Whitelisted
    public void publish(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareNpmStep(args, Arrays.asList("path", "buildInfo"));
        this.cpsScript.invokeMethod("artifactoryNpmPublish", stepVariables);
    }

    private Map<String, Object> prepareNpmStep(Map<String, Object> args, List<String> keysAsList) {
        Set<String> npmArgumentsSet = args.keySet();
        if (!keysAsList.containsAll(npmArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getRunArguments((String)args.get("path"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        return stepVariables;
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("repo", "server"));
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        this.setDeployer(deployerArguments, Arrays.asList("repo", "server", "deployArtifacts", "includeEnvVars"));
    }

    private Map<String, Object> getRunArguments(String path, BuildInfo buildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("npmBuild", this);
        stepVariables.put("path", path);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

