/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.packageManagerBuilds;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.MavenDeployer;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.MavenResolver;

public class MavenBuild
extends PackageManagerBuild {
    private String opts = "";

    public MavenBuild() {
        this.deployer = new MavenDeployer();
        this.resolver = new MavenResolver();
    }

    @Override
    @Whitelisted
    public MavenResolver getResolver() {
        return (MavenResolver)this.resolver;
    }

    @Override
    @Whitelisted
    public String getTool() {
        return this.tool;
    }

    @Override
    @Whitelisted
    public void setTool(String tool) {
        this.tool = tool;
    }

    @Whitelisted
    public String getOpts() {
        return this.opts;
    }

    @Whitelisted
    public void setOpts(String opts) {
        this.opts = opts;
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        if (!args.containsKey("goals") || !args.containsKey("pom")) {
            throw new IllegalArgumentException("pom and goals are mandatory arguments.");
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getExecutionArguments((String)args.get("pom"), (String)args.get("goals"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryMavenBuild", stepVariables);
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("releaseRepo", "snapshotRepo", "server"));
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        this.setDeployer(deployerArguments, Arrays.asList("releaseRepo", "snapshotRepo", "server", "evenIfUnstable", "deployArtifacts", "includeEnvVars"));
    }

    private Map<String, Object> getExecutionArguments(String pom, String goals, BuildInfo buildInfo) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("mavenBuild", this);
        stepVariables.put("pom", pom);
        stepVariables.put("goals", goals);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

