/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.deployers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class GradleDeployer
extends Deployer {
    private Boolean deployMavenDescriptors;
    private Boolean deployIvyDescriptors;
    private String ivyPattern = "[organisation]/[module]/ivy-[revision].xml";
    private String artifactPattern = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
    private boolean mavenCompatible = true;
    private String repo;

    @Override
    @JsonIgnore
    public ServerDetails getDetails() {
        RepositoryConf releaesRepositoryConf = new RepositoryConf(this.repo, this.repo, false);
        String serverName = this.server == null ? "" : this.server.getServerName();
        String url = this.server == null ? "" : this.server.getUrl();
        return new ServerDetails(serverName, url, releaesRepositoryConf, null, releaesRepositoryConf, null, "", "");
    }

    @Whitelisted
    public Boolean isDeployMavenDescriptors() {
        return this.deployMavenDescriptors;
    }

    @Whitelisted
    public void setDeployMavenDescriptors(boolean deployMavenDescriptors) {
        this.deployMavenDescriptors = deployMavenDescriptors;
    }

    @Whitelisted
    public Boolean isDeployIvyDescriptors() {
        return this.deployIvyDescriptors;
    }

    @Whitelisted
    public void setDeployIvyDescriptors(boolean deployIvyDescriptors) {
        this.deployIvyDescriptors = deployIvyDescriptors;
    }

    @Whitelisted
    public String getIvyPattern() {
        return this.ivyPattern;
    }

    @Whitelisted
    public void setIvyPattern(String ivyPattern) {
        this.ivyPattern = ivyPattern;
    }

    @Whitelisted
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Whitelisted
    public void setArtifactPattern(String artifactPattern) {
        this.artifactPattern = artifactPattern;
    }

    @Whitelisted
    public boolean getMavenCompatible() {
        return this.mavenCompatible;
    }

    @Whitelisted
    public void setMavenCompatible(boolean mavenCompatible) {
        this.mavenCompatible = mavenCompatible;
    }

    @Whitelisted
    public boolean isMavenCompatible() {
        return this.mavenCompatible;
    }

    @Whitelisted
    public String getRepo() {
        return this.repo;
    }

    @Whitelisted
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @Override
    public boolean isEmpty() {
        return this.server == null || StringUtils.isEmpty((String)this.repo);
    }

    @Override
    public String getTargetRepository(String deployPath) {
        return this.repo;
    }

    @Override
    @JsonIgnore
    public PublisherContext.Builder getContextBuilder() {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).serverDetails(this.getDetails()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(Utils.getArtifactsIncludeExcludeForDeyployment(this.getArtifactDeploymentPatterns().getPatternFilter())).skipBuildInfoDeploy(!this.isDeployBuildInfo()).artifactsPattern(this.getArtifactPattern()).ivyPattern(this.getIvyPattern()).deployIvy(this.isDeployIvyDescriptors()).deployMaven(this.isDeployMavenDescriptors()).deployerOverrider(this).includeEnvVars(this.isIncludeEnvVars()).maven2Compatible(this.getMavenCompatible()).deploymentProperties(ExtractorUtils.buildPropertiesString(this.getProperties())).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion());
    }
}

