/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;

public class Docker
implements Serializable {
    private transient CpsScript cpsScript;
    private String host;
    private ArrayListMultimap<String, String> properties = ArrayListMultimap.create();
    private ArtifactoryServer server;

    public Docker() {
    }

    public Docker(CpsScript script, String host) {
        this.cpsScript = script;
        this.host = host;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setServer(ArtifactoryServer server) {
        this.server = server;
    }

    @Whitelisted
    public Docker addProperty(String key, String ... values) {
        this.properties.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    @Whitelisted
    public void push(String imageTag, String targetRepository) {
        this.push(imageTag, targetRepository, null);
    }

    @Whitelisted
    public void push(String imageTag, String targetRepository, BuildInfo providedBuildInfo) {
        LinkedHashMap dockerArguments = Maps.newLinkedHashMap();
        dockerArguments.put("image", imageTag);
        dockerArguments.put("targetRepo", targetRepository);
        dockerArguments.put("buildInfo", providedBuildInfo);
        this.push(dockerArguments);
    }

    @Whitelisted
    public void push(Map<String, Object> dockerArguments) {
        dockerArguments.put("host", this.host);
        dockerArguments.put("properties", this.properties);
        dockerArguments.put("server", this.server);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        this.cpsScript.invokeMethod("dockerPushStep", dockerArguments);
    }

    @Whitelisted
    public void pull(String imageTag) {
        this.pull(imageTag, null);
    }

    @Whitelisted
    public void pull(String imageTag, BuildInfo providedBuildInfo) {
        LinkedHashMap dockerArguments = Maps.newLinkedHashMap();
        dockerArguments.put("image", imageTag);
        dockerArguments.put("buildInfo", providedBuildInfo);
        this.pull(dockerArguments);
    }

    @Whitelisted
    public void pull(Map<String, Object> dockerArguments) {
        dockerArguments.put("host", this.host);
        dockerArguments.put("server", this.server);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        this.cpsScript.invokeMethod("dockerPullStep", dockerArguments);
    }
}

