/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.Jenkins;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryDependenciesClientBuilder;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.npm.NpmInstallCallable;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.NpmBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.NpmResolver;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class NpmInstallExecutor
implements Executor {
    private BuildInfo buildInfo;
    private NpmBuild npmBuild;
    private String npmExe;
    private String args;
    private FilePath ws;
    private String path;
    private EnvVars env;
    private Log logger;
    private Run build;

    public NpmInstallExecutor(BuildInfo buildInfo, NpmBuild npmBuild, String npmExe, String args, FilePath ws, String path, EnvVars env, TaskListener listener, Run build) {
        this.buildInfo = Utils.prepareBuildinfo(build, buildInfo);
        this.npmBuild = npmBuild;
        this.npmExe = npmExe;
        this.args = args;
        this.ws = ws;
        this.path = path;
        this.env = env;
        this.logger = new JenkinsBuildInfoLog(listener);
        this.build = build;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public void execute() throws Exception {
        NpmResolver resolver = (NpmResolver)this.npmBuild.getResolver();
        if (resolver.isEmpty()) {
            throw new IllegalStateException("Resolver must be configured with resolution repository and Artifactory server");
        }
        Build build = (Build)this.ws.act((FilePath.FileCallable)new NpmInstallCallable(this.createArtifactoryClientBuilder(resolver), resolver.getRepo(), this.npmExe, this.args, this.path, this.env, this.logger));
        if (build == null) {
            throw new RuntimeException("npm build failed");
        }
        this.buildInfo.append(build);
        this.buildInfo.setAgentName(Utils.getAgentName(this.ws));
    }

    private ArtifactoryDependenciesClientBuilder createArtifactoryClientBuilder(NpmResolver resolver) {
        ArtifactoryServer server = resolver.getArtifactoryServer();
        CredentialsConfig preferredResolver = server.getResolvingCredentialsConfig();
        return (ArtifactoryDependenciesClientBuilder)((ArtifactoryDependenciesClientBuilder)((ArtifactoryDependenciesClientBuilder)((ArtifactoryDependenciesClientBuilder)((ArtifactoryDependenciesClientBuilder)((ArtifactoryDependenciesClientBuilder)((ArtifactoryDependenciesClientBuilder)new ArtifactoryDependenciesClientBuilder().setArtifactoryUrl(server.getUrl())).setUsername(preferredResolver.provideUsername((Item)this.build.getParent()))).setPassword(preferredResolver.providePassword((Item)this.build.getParent()))).setProxyConfiguration(ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy))).setLog(this.logger)).setConnectionRetry(server.getConnectionRetry())).setConnectionTimeout(server.getTimeout());
    }
}

