/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class MavenGradleEnvExtractor
implements Executor {
    private Deployer publisher;
    private Resolver resolver;
    private Run build;
    private BuildInfo buildInfo;
    private TaskListener buildListener;
    private Launcher launcher;
    private FilePath tempDir;
    private EnvVars env;

    public MavenGradleEnvExtractor(Run build, BuildInfo buildInfo, Deployer publisher, Resolver resolver, TaskListener buildListener, Launcher launcher, FilePath tempDir, EnvVars env) {
        this.build = build;
        this.buildInfo = buildInfo;
        this.buildListener = buildListener;
        this.publisher = publisher;
        this.resolver = resolver;
        this.launcher = launcher;
        this.tempDir = tempDir;
        this.env = env;
    }

    private PublisherContext createPublisherContext() {
        return this.publisher.getContextBuilder().build();
    }

    @Override
    public void execute() {
        this.env.put("extractor.used", "true");
        ReleaseAction release = ActionableHelper.getLatestAction(this.build, ReleaseAction.class);
        if (release != null) {
            release.addVars((Map<String, String>)this.env);
        }
        try {
            PublisherContext publisherContext = this.createPublisherContext();
            ResolverContext resolverContext = null;
            if (this.resolver != null && !this.resolver.isEmpty()) {
                CredentialsConfig resolverCredentials = CredentialManager.getPreferredResolver(this.resolver, this.resolver.getArtifactoryServer());
                resolverContext = new ResolverContext(this.resolver.getArtifactoryServer(), this.resolver.getResolverDetails(), resolverCredentials.getCredentials((Item)this.build.getParent()), this.resolver);
            }
            ArtifactoryClientConfiguration configuration = ExtractorUtils.getArtifactoryClientConfiguration((Map<String, String>)this.env, this.build, this.buildInfo, this.buildListener, publisherContext, resolverContext);
            this.addPipelineInfoToConfiguration(this.env, configuration, this.tempDir);
            ExtractorUtils.persistConfiguration(configuration, (Map<String, String>)this.env, this.tempDir, this.launcher);
            String propertiesFilePath = configuration.getPropertiesFile();
            this.env.put("buildInfoConfig.propertiesFile", propertiesFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addPipelineInfoToConfiguration(EnvVars env, ArtifactoryClientConfiguration configuration, FilePath tempDir) {
        String deployableArtifactsFile;
        String buildInfoTempFile;
        try {
            buildInfoTempFile = Utils.createTempJsonFile(this.launcher, "generated.build.info", tempDir.getRemote());
            deployableArtifactsFile = Utils.createTempJsonFile(this.launcher, "deployable.artifacts", tempDir.getRemote());
        }
        catch (Exception e) {
            this.buildListener.error("Failed while generating temp file. " + e.getMessage());
            this.build.setResult(Result.FAILURE);
            throw new Run.RunnerAbortedException();
        }
        env.put("generated.build.info", buildInfoTempFile);
        configuration.info.setGeneratedBuildInfoFilePath(buildInfoTempFile);
        env.put("deployable.artifacts", deployableArtifactsFile);
        configuration.info.setDeployableArtifactsFilePath(deployableArtifactsFile);
    }
}

