/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.gradle.Gradle;
import hudson.plugins.gradle.GradleInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.gradle.GradleInitScriptWriter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.executors.MavenGradleEnvExtractor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.GradleBuild;
import org.jfrog.hudson.util.ExtractorUtils;

public class GradleExecutor
implements Executor {
    private EnvVars env;
    private EnvVars extendedEnv;
    private GradleBuild gradleBuild;
    private TaskListener listener;
    private FilePath tempDir;
    private FilePath ws;
    private BuildInfo buildInfo;
    private Launcher launcher;
    private String initScriptPath;
    private String buildFile;
    private String switches;
    private String rootDir;
    private String tasks;
    private Run build;

    public GradleExecutor(Run build, GradleBuild gradleBuild, String tasks, String buildFile, String rootDir, String switches, BuildInfo buildInfo, EnvVars env, FilePath ws, TaskListener listener, Launcher launcher) {
        this.build = build;
        this.gradleBuild = gradleBuild;
        this.tasks = Objects.toString(tasks, "artifactoryPublish");
        this.buildFile = StringUtils.defaultIfEmpty((String)buildFile, (String)"build.gradle");
        this.rootDir = Objects.toString(rootDir, "");
        this.switches = Objects.toString(switches, "");
        this.buildInfo = buildInfo;
        this.env = env;
        this.ws = ws;
        this.listener = listener;
        this.launcher = launcher;
    }

    @Override
    public void execute() throws Exception {
        this.buildInfo = Utils.prepareBuildinfo(this.build, this.buildInfo);
        Deployer deployer = this.gradleBuild.getDeployer();
        deployer.createPublisherBuildInfoDetails(this.buildInfo);
        String revision = Utils.extractVcsRevision(new FilePath(this.ws, this.rootDir));
        this.extendedEnv = new EnvVars(this.env);
        this.extendedEnv.put("GIT_COMMIT", revision);
        this.tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        MavenGradleEnvExtractor envExtractor = new MavenGradleEnvExtractor(this.build, this.buildInfo, deployer, this.gradleBuild.getResolver(), this.listener, this.launcher, this.tempDir, this.extendedEnv);
        envExtractor.execute();
        ArgumentListBuilder args = this.getGradleExecutor();
        this.exe(args);
        String generatedBuildPath = (String)this.extendedEnv.get((Object)"generated.build.info");
        this.buildInfo.append(Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, generatedBuildPath));
        ActionableHelper.deleteFilePath(this.tempDir, this.initScriptPath);
        this.buildInfo.appendDeployableArtifacts((String)this.extendedEnv.get((Object)"deployable.artifacts"), this.tempDir, this.listener);
        this.buildInfo.setAgentName(Utils.getAgentName(this.ws));
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    private ArgumentListBuilder getGradleExecutor() {
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (this.gradleBuild.isUseWrapper()) {
            String execName = this.launcher.isUnix() ? "gradlew" : "gradlew.bat";
            FilePath gradleWrapperFile = new FilePath(new FilePath(this.ws, this.rootDir), execName);
            args.add(gradleWrapperFile.getRemote());
        } else {
            try {
                args.add(this.getGradleExe());
            }
            catch (Exception e) {
                this.listener.error("Couldn't find Gradle executable.");
                this.build.setResult(Result.FAILURE);
                throw new Run.RunnerAbortedException();
            }
        }
        args.addTokenized(this.getSwitches()).addTokenized(this.tasks).add(new String[]{"-b", this.getBuildFileFullPath()});
        if (!this.launcher.isUnix()) {
            args = args.toWindowsCommand();
        }
        return args;
    }

    private String getBuildFileFullPath() {
        StringBuilder buildFile = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.rootDir)) {
            String pathsDelimiter = this.launcher.isUnix() ? "/" : "\\";
            buildFile.append(this.rootDir);
            if (!StringUtils.endsWith((String)this.rootDir, (String)pathsDelimiter)) {
                buildFile.append(pathsDelimiter);
            }
        }
        buildFile.append(this.buildFile);
        return buildFile.toString();
    }

    private String getSwitches() {
        String switches = this.switches;
        if (!this.gradleBuild.isUsesPlugin()) {
            try {
                this.initScriptPath = this.createInitScript();
                switches = switches + " --init-script " + this.initScriptPath;
            }
            catch (Exception e) {
                this.listener.getLogger().println("Error occurred while writing Gradle Init Script: " + e.getMessage());
                this.build.setResult(Result.FAILURE);
            }
        }
        return switches;
    }

    private void exe(ArgumentListBuilder args) {
        boolean failed;
        try {
            int exitValue = this.launcher.launch().cmds(args).envs((Map)this.extendedEnv).stdout(this.listener).stderr((OutputStream)this.listener.getLogger()).pwd(this.ws).join();
            failed = exitValue != 0;
        }
        catch (Exception e) {
            this.listener.error("Couldn't execute gradle task. " + e.getMessage());
            failed = true;
        }
        if (failed) {
            this.build.setResult(Result.FAILURE);
            throw new Run.RunnerAbortedException();
        }
    }

    private GradleInstallation getGradleInstallation() {
        if (!StringUtils.isEmpty((String)this.gradleBuild.getTool())) {
            GradleInstallation[] installations;
            for (GradleInstallation i : installations = ((Gradle.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Gradle.DescriptorImpl.class)).getInstallations()) {
                if (!this.gradleBuild.getTool().equals(i.getName())) continue;
                return i;
            }
        }
        return null;
    }

    private String getGradleExe() throws IOException, InterruptedException {
        if (StringUtils.isNotEmpty((String)this.gradleBuild.getTool())) {
            GradleInstallation gi = this.getGradleInstallation();
            if (gi == null) {
                this.listener.error("Couldn't find Gradle executable.");
                throw new Run.RunnerAbortedException();
            }
            Node node = ActionableHelper.getNode(this.launcher);
            gi = gi.forNode(node, this.listener);
            gi = gi.forEnvironment(this.extendedEnv);
            this.extendedEnv.put("GRADLE_HOME", gi.getHome());
            String gradleExe = gi.getExecutable(this.launcher);
            if (gradleExe != null) {
                return gradleExe;
            }
        }
        if (!this.extendedEnv.containsKey((Object)"GRADLE_HOME")) {
            throw new RuntimeException("Couldn't find gradle installation");
        }
        return (String)this.extendedEnv.get((Object)"GRADLE_HOME") + "/bin/gradle";
    }

    private String createInitScript() throws Exception {
        GradleInitScriptWriter writer = new GradleInitScriptWriter(this.tempDir);
        FilePath initScript = this.tempDir.createTextTempFile("init-artifactory", "gradle", writer.generateInitScript(this.env));
        ActionableHelper.deleteFilePathOnExit(initScript);
        String initScriptPath = initScript.getRemote();
        initScriptPath = initScriptPath.replace('\\', '/');
        return initScriptPath;
    }
}

