/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.model.Item;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.acls.NotFoundException;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.util.RepositoriesUtils;

public class GetArtifactoryServerExecutor
implements Executor {
    private Run build;
    private StepContext stepContext;
    private String artifactoryServerID;
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer artifactoryServer;

    public GetArtifactoryServerExecutor(Run build, StepContext stepContext, String artifactoryServerID) {
        this.build = build;
        this.stepContext = stepContext;
        this.artifactoryServerID = artifactoryServerID;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getArtifactoryServer() {
        return this.artifactoryServer;
    }

    @Override
    public void execute() {
        if (StringUtils.isEmpty((String)this.artifactoryServerID)) {
            this.stepContext.onFailure((Throwable)new MissingArgumentException("Artifactory server name is mandatory"));
        }
        ArrayList<ArtifactoryServer> artifactoryServers = new ArrayList<ArtifactoryServer>();
        List<ArtifactoryServer> artifactoryConfiguredServers = RepositoriesUtils.getArtifactoryServers();
        if (artifactoryConfiguredServers == null) {
            this.stepContext.onFailure((Throwable)new NotFoundException("No Artifactory servers were configured"));
            return;
        }
        for (ArtifactoryServer server : artifactoryConfiguredServers) {
            if (!server.getName().equals(this.artifactoryServerID)) continue;
            artifactoryServers.add(server);
        }
        if (artifactoryServers.isEmpty()) {
            this.stepContext.onFailure((Throwable)new NotFoundException("Couldn't find Artifactory server with ID: " + this.artifactoryServerID));
        }
        if (artifactoryServers.size() > 1) {
            throw new RuntimeException("Duplicate configured Artifactory server ID: " + this.artifactoryServerID);
        }
        ArtifactoryServer server = (ArtifactoryServer)artifactoryServers.get(0);
        this.artifactoryServer = new org.jfrog.hudson.pipeline.common.types.ArtifactoryServer(this.artifactoryServerID, server.getUrl(), server.getResolvingCredentialsConfig().provideUsername((Item)this.build.getParent()), server.getResolvingCredentialsConfig().providePassword((Item)this.build.getParent()), server.getDeploymentThreads());
        this.artifactoryServer.setBypassProxy(server.isBypassProxy());
        this.artifactoryServer.getConnection().setRetry(server.getConnectionRetry());
        this.artifactoryServer.getConnection().setTimeout(server.getTimeout());
    }
}

