/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.generic.GenericArtifactsDeployer;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.util.Credentials;

public class GenericUploadExecutor
implements Executor {
    private transient FilePath ws;
    private transient Run build;
    private transient TaskListener listener;
    private BuildInfo buildInfo;
    private boolean failNoOp;
    private ArtifactoryServer server;
    private StepContext context;
    private String spec;

    public GenericUploadExecutor(ArtifactoryServer server, TaskListener listener, Run build, FilePath ws, BuildInfo buildInfo, StepContext context, String spec, boolean failNoOp) {
        this.server = server;
        this.listener = listener;
        this.build = build;
        this.buildInfo = Utils.prepareBuildinfo(build, buildInfo);
        this.ws = ws;
        this.context = context;
        this.spec = spec;
        this.failNoOp = failNoOp;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        Credentials credentials = new Credentials(this.server.getDeployerCredentialsConfig().provideUsername((Item)this.build.getParent()), this.server.getDeployerCredentialsConfig().providePassword((Item)this.build.getParent()));
        ProxyConfiguration proxyConfiguration = Utils.getProxyConfiguration(this.server);
        List deployedArtifacts = (List)this.ws.act((FilePath.FileCallable)new GenericArtifactsDeployer.FilesDeployerCallable(this.listener, this.spec, this.server, credentials, Utils.getPropertiesMap(this.buildInfo, this.build, this.context), proxyConfiguration));
        if (this.failNoOp && deployedArtifacts.isEmpty()) {
            throw new RuntimeException("Fail-no-op: No files were affected in the upload process.");
        }
        new BuildInfoAccessor(this.buildInfo).appendDeployedArtifacts(deployedArtifacts);
    }
}

