/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.generic.FilesResolverCallable;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class GenericDownloadExecutor
implements Executor {
    private final Run build;
    private transient FilePath ws;
    private BuildInfo buildInfo;
    private boolean failNoOp;
    private ArtifactoryServer server;
    private TaskListener listener;
    private String spec;

    public GenericDownloadExecutor(ArtifactoryServer server, TaskListener listener, Run build, FilePath ws, BuildInfo buildInfo, String spec, boolean failNoOp) {
        this.build = build;
        this.server = server;
        this.listener = listener;
        this.buildInfo = Utils.prepareBuildinfo(build, buildInfo);
        this.failNoOp = failNoOp;
        this.ws = ws;
        this.spec = spec;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        CredentialsConfig preferredResolver = this.server.getDeployerCredentialsConfig();
        List resolvedDependencies = (List)this.ws.act((FilePath.FileCallable)new FilesResolverCallable(new JenkinsBuildInfoLog(this.listener), preferredResolver.provideUsername((Item)this.build.getParent()), preferredResolver.providePassword((Item)this.build.getParent()), this.server.getUrl(), this.spec, Utils.getProxyConfiguration(this.server)));
        if (this.failNoOp && resolvedDependencies.isEmpty()) {
            throw new RuntimeException("Fail-no-op: No files were affected in the download process.");
        }
        new BuildInfoAccessor(this.buildInfo).appendPublishedDependencies(resolvedDependencies);
    }
}

