/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.docker.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.pipeline.common.Utils;

public class DockerUtils
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageIdFromTag(String imageTag, String host) throws IOException {
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerUtils.getDockerClient(host);
            String string = dockerClient.inspectImageCmd(imageTag).exec().getId();
            return string;
        }
        finally {
            DockerUtils.closeQuietly(dockerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushImage(String imageTag, String username, String password, String host) throws IOException {
        AuthConfig authConfig = new AuthConfig();
        authConfig.withUsername(username);
        authConfig.withPassword(password);
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerUtils.getDockerClient(host);
            ((PushImageResultCallback)dockerClient.pushImageCmd(imageTag).withAuthConfig(authConfig).exec((ResultCallback)new PushImageResultCallback())).awaitSuccess();
        }
        finally {
            DockerUtils.closeQuietly(dockerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pullImage(String imageTag, String username, String password, String host) throws IOException {
        AuthConfig authConfig = new AuthConfig();
        authConfig.withUsername(username);
        authConfig.withPassword(password);
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerUtils.getDockerClient(host);
            ((PullImageResultCallback)dockerClient.pullImageCmd(imageTag).withAuthConfig(authConfig).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        }
        finally {
            DockerUtils.closeQuietly(dockerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getParentId(String digest, String host) throws IOException {
        DockerClient dockerClient = null;
        try {
            dockerClient = DockerUtils.getDockerClient(host);
            String string = dockerClient.inspectImageCmd(digest).exec().getParent();
            return string;
        }
        finally {
            DockerUtils.closeQuietly(dockerClient);
        }
    }

    public static String getConfigDigest(String manifest) throws IOException {
        JsonNode manifestTree = Utils.mapper().readTree(manifest);
        JsonNode schemaVersion = manifestTree.get("schemaVersion");
        if (schemaVersion == null) {
            throw new IllegalStateException("Could not find 'schemaVersion' in manifest");
        }
        if (schemaVersion.asInt() == 1) {
            throw new IllegalStateException("Docker build info is not supported for docker V1 images");
        }
        JsonNode config = manifestTree.get("config");
        if (config == null) {
            throw new IllegalStateException("Could not find 'config' in manifest");
        }
        JsonNode digest = config.get("digest");
        if (digest == null) {
            throw new IllegalStateException("Could not find config digest in manifest");
        }
        return StringUtils.remove((String)digest.toString(), (String)"\"");
    }

    public static List<String> getLayersDigests(String manifestContent) throws IOException {
        ArrayList<String> dockerLayersDependencies = new ArrayList<String>();
        JsonNode manifest = Utils.mapper().readTree(manifestContent);
        JsonNode schemaVersion = manifest.get("schemaVersion");
        if (schemaVersion == null) {
            throw new IllegalStateException("Could not find 'schemaVersion' in manifest");
        }
        boolean isSchemeVersion1 = schemaVersion.asInt() == 1;
        JsonNode fsLayers = DockerUtils.getFsLayers(manifest, isSchemeVersion1);
        for (JsonNode fsLayer : fsLayers) {
            JsonNode blobSum = DockerUtils.getBlobSum(isSchemeVersion1, fsLayer);
            dockerLayersDependencies.add(blobSum.asText());
        }
        dockerLayersDependencies.add(DockerUtils.getConfigDigest(manifestContent));
        String manifestSha1 = Hashing.sha1().hashString((CharSequence)manifestContent, Charsets.UTF_8).toString();
        dockerLayersDependencies.add("sha1:" + manifestSha1);
        return dockerLayersDependencies;
    }

    private static JsonNode getFsLayers(JsonNode manifest, boolean isSchemeVersion1) {
        JsonNode fsLayers = isSchemeVersion1 ? manifest.get("fsLayers") : manifest.get("layers");
        if (fsLayers == null) {
            throw new IllegalStateException("Could not find 'fsLayers' or 'layers' in manifest");
        }
        return fsLayers;
    }

    private static JsonNode getBlobSum(boolean isSchemeVersion1, JsonNode fsLayer) {
        JsonNode blobSum = isSchemeVersion1 ? fsLayer.get("blobSum") : fsLayer.get("digest");
        if (blobSum == null) {
            throw new IllegalStateException("Could not find 'blobSub' or 'digest' in manifest");
        }
        return blobSum;
    }

    public static String getShaValue(String digest) {
        return StringUtils.substring((String)digest, (int)(StringUtils.indexOf((String)digest, (String)":") + 1));
    }

    public static String getShaVersion(String digest) {
        return StringUtils.substring((String)digest, (int)0, (int)StringUtils.indexOf((String)digest, (String)":"));
    }

    public static String getImagePath(String imageTag) {
        String imageVersion;
        String imageName;
        int indexOfSlash = imageTag.indexOf("/");
        int indexOfLastColon = imageTag.lastIndexOf(":");
        if (indexOfLastColon < 0 || indexOfLastColon < indexOfSlash) {
            imageName = imageTag.substring(indexOfSlash + 1);
            imageVersion = "latest";
        } else {
            imageName = imageTag.substring(indexOfSlash + 1, indexOfLastColon);
            imageVersion = imageTag.substring(indexOfLastColon + 1);
        }
        return imageName + "/" + imageVersion;
    }

    public static Boolean isImageVersioned(String imageTag) {
        int indexOfLastColon;
        int indexOfFirstSlash = imageTag.indexOf("/");
        return indexOfFirstSlash < (indexOfLastColon = imageTag.lastIndexOf(":"));
    }

    public static String fileNameToDigest(String fileName) {
        return StringUtils.replace((String)fileName, (String)"__", (String)":");
    }

    public static String digestToFileName(String digest) {
        if (StringUtils.startsWith((String)digest, (String)"sha1")) {
            return "manifest.json";
        }
        return DockerUtils.getShaVersion(digest) + "__" + DockerUtils.getShaValue(digest);
    }

    public static int getNumberOfDependentLayers(String imageContent) throws IOException {
        JsonNode history = Utils.mapper().readTree(imageContent).get("history");
        if (history == null) {
            throw new IllegalStateException("Could not find 'history' tag");
        }
        int layersNum = history.size();
        boolean newImageLayers = true;
        for (int i = history.size() - 1; i >= 0; --i) {
            String createdBy;
            if (newImageLayers) {
                --layersNum;
            }
            JsonNode layer = history.get(i);
            JsonNode emptyLayer = layer.get("empty_layer");
            if (!newImageLayers && emptyLayer != null) {
                --layersNum;
            }
            if (layer.get("created_by") == null || !(createdBy = layer.get("created_by").textValue()).contains("ENTRYPOINT") && !createdBy.contains("MAINTAINER")) continue;
            newImageLayers = false;
        }
        return layersNum;
    }

    private static DockerClient getDockerClient(String host) {
        NettyDockerCmdExecFactory nettyDockerCmdExecFactory = new NettyDockerCmdExecFactory();
        if (StringUtils.isEmpty((String)host)) {
            return DockerClientBuilder.getInstance().withDockerCmdExecFactory((DockerCmdExecFactory)nettyDockerCmdExecFactory).build();
        }
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(host).build();
        return DockerClientBuilder.getInstance((DockerClientConfig)config).withDockerCmdExecFactory((DockerCmdExecFactory)nettyDockerCmdExecFactory).build();
    }

    private static void closeQuietly(DockerClient dockerClient) {
        if (dockerClient != null) {
            try {
                dockerClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

