/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.npm;

import hudson.EnvVars;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryDependenciesClientBuilder;
import org.jfrog.build.extractor.npm.extractor.NpmInstall;
import org.jfrog.hudson.pipeline.common.Utils;

public class NpmInstallCallable
extends MasterToSlaveFileCallable<Build> {
    private ArtifactoryDependenciesClientBuilder dependenciesClientBuilder;
    private String resolutionRepository;
    private String executablePath;
    private String args;
    private String path;
    private EnvVars env;
    private Log logger;

    public NpmInstallCallable(ArtifactoryDependenciesClientBuilder dependenciesClientBuilder, String resolutionRepository, String executablePath, String args, String path, EnvVars env, Log logger) {
        this.dependenciesClientBuilder = dependenciesClientBuilder;
        this.resolutionRepository = resolutionRepository;
        this.executablePath = executablePath;
        this.args = Objects.toString(args, "");
        this.path = path;
        this.env = env;
        this.logger = logger;
    }

    public Build invoke(File file, VirtualChannel channel) {
        Path basePath = file.toPath();
        Path packagePath = StringUtils.isBlank((CharSequence)this.path) ? basePath : basePath.resolve(Utils.replaceTildeWithUserHome(this.path));
        return new NpmInstall(this.dependenciesClientBuilder, this.resolutionRepository, this.args, this.executablePath, this.logger, packagePath, (Map)this.env).execute();
    }
}

