/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3;

import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.maven3.Messages;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.util.PluginDependencyHelper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Maven3Builder
extends Builder {
    public static final String CLASSWORLDS_LAUNCHER = "org.codehaus.plexus.classworlds.launcher.Launcher";
    public static final String MAVEN_HOME = "MAVEN_HOME";
    private final String mavenName;
    private final String rootPom;
    private final String goals;
    private final String mavenOpts;
    private String classworldsConfPath;

    @DataBoundConstructor
    public Maven3Builder(String mavenName, String rootPom, String goals, String mavenOpts) {
        this.mavenName = mavenName;
        this.rootPom = rootPom;
        this.goals = goals;
        this.mavenOpts = mavenOpts;
    }

    public String getMavenName() {
        return this.mavenName;
    }

    public String getRootPom() {
        return this.rootPom;
    }

    public String getGoals() {
        return this.goals;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        EnvVars env = build.getEnvironment((TaskListener)listener);
        FilePath workDir = build.getModuleRoot();
        FilePath ws = build.getWorkspace();
        FilePath mavenHome = this.getMavenHome((TaskListener)listener, env, launcher);
        if (!mavenHome.exists()) {
            listener.error("Couldn't find Maven home: " + mavenHome.getRemote());
            throw new Run.RunnerAbortedException();
        }
        ArgumentListBuilder cmdLine = this.buildMavenCmdLine((Run<?, ?>)build, (TaskListener)listener, env, launcher, mavenHome, ws, ws);
        String[] cmds = cmdLine.toCommandArray();
        return this.RunMaven((Run<?, ?>)build, launcher, (TaskListener)listener, env, workDir, cmds);
    }

    public boolean perform(Run<?, ?> build, Launcher launcher, TaskListener listener, EnvVars env, FilePath workDir, FilePath tempDir) throws InterruptedException, IOException {
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        FilePath mavenHome = this.getMavenHome(listener, env, launcher);
        if (!mavenHome.exists()) {
            listener.getLogger().println("Couldn't find Maven home at " + mavenHome.getRemote() + " on agent " + Utils.getAgentName(workDir) + ". This could be because this build is running inside a Docker container.");
        }
        ArgumentListBuilder cmdLine = this.buildMavenCmdLine(build, listener, env, launcher, mavenHome, workDir, tempDir);
        String[] cmds = cmdLine.toCommandArray();
        return this.RunMaven(build, launcher, listener, env, workDir, cmds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean RunMaven(Run<?, ?> build, Launcher launcher, TaskListener listener, EnvVars env, FilePath workDir, String[] cmds) throws InterruptedException, IOException {
        try {
            int exitValue = launcher.launch().cmds(cmds).envs((Map)env).stdout(listener).stderr((OutputStream)listener.getLogger()).pwd(workDir).join();
            boolean success = exitValue == 0;
            build.setResult(success ? Result.SUCCESS : Result.FAILURE);
            boolean bl = success;
            return bl;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            boolean bl = false;
            return bl;
        }
        finally {
            ActionableHelper.deleteFilePath(workDir, this.classworldsConfPath);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private ArgumentListBuilder buildMavenCmdLine(Run<?, ?> build, TaskListener listener, EnvVars env, Launcher launcher, FilePath mavenHome, FilePath ws, FilePath tempDir) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getJavaPathBuilder((String)env.get((Object)"PATH+JDK"), launcher));
        String fileSeparator = this.getFileSeparator(launcher);
        Object[] pathsToJoin = new String[]{mavenHome.getRemote(), "boot", "*"};
        args.add(new String[]{"-classpath", StringUtils.join((Object[])pathsToJoin, (String)fileSeparator)});
        args.addKeyValuePair("-D", "maven.home", mavenHome.getRemote(), false);
        FilePath mavenConf = mavenHome.child("conf");
        args.addKeyValuePair("-D", "maven.conf", mavenConf.getRemote(), false);
        String buildInfoPropertiesFile = (String)env.get((Object)"buildInfoConfig.propertiesFile");
        boolean artifactoryIntegration = StringUtils.isNotBlank((String)buildInfoPropertiesFile);
        listener.getLogger().println("Artifactory integration is " + (artifactoryIntegration ? "enabled" : "disabled"));
        if (artifactoryIntegration) {
            this.addArtifactoryIntegrationArgs(args, buildInfoPropertiesFile, tempDir, env);
            ActionableHelper.deleteFilePathOnExit(tempDir, this.classworldsConfPath);
        } else {
            args.addKeyValuePair("-D", "classworlds.conf", new FilePath(mavenHome, "bin/m2.conf").getRemote(), false);
        }
        args.addKeyValuePair("-D", "maven.multiModuleProjectDirectory", this.getMavenProjectPath(build, ws), false);
        this.addMavenOpts(args, build);
        args.add(CLASSWORLDS_LAUNCHER);
        String rootPom = this.getRootPom();
        if (StringUtils.isNotBlank((String)rootPom)) {
            args.add(new String[]{"-f", rootPom});
        }
        args.addTokenized(Util.replaceMacro((String)this.getGoals(), (Map)env));
        return args;
    }

    private String getFileSeparator(Launcher launcher) {
        String fileSeparator = "/";
        if (!launcher.isUnix()) {
            fileSeparator = "\\";
        }
        return fileSeparator;
    }

    private String getJavaPathBuilder(String jdkBinPath, Launcher launcher) {
        StringBuilder javaPathBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)jdkBinPath)) {
            javaPathBuilder.append(jdkBinPath).append("/");
        }
        javaPathBuilder.append("java");
        if (!launcher.isUnix()) {
            javaPathBuilder.append(".exe");
        }
        return javaPathBuilder.toString();
    }

    private void addArtifactoryIntegrationArgs(ArgumentListBuilder args, String buildInfoPropertiesFile, FilePath ws, EnvVars env) throws IOException, InterruptedException {
        args.addKeyValuePair("-D", "buildInfoConfig.propertiesFile", buildInfoPropertiesFile, false);
        if (Boolean.parseBoolean((String)env.get((Object)"buildInfoConfig.artifactoryResolutionEnabled"))) {
            args.addKeyValuePair("-D", "buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString(), false);
        }
        File extractorJar = PluginDependencyHelper.getExtractorJar(env);
        FilePath actualDependencyDirectory = PluginDependencyHelper.getActualDependencyDirectory(extractorJar, ws);
        if (this.getMavenOpts() == null || !this.getMavenOpts().contains("-Dm3plugin.lib")) {
            args.addKeyValuePair("-D", "m3plugin.lib", actualDependencyDirectory.getRemote(), false);
        }
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/jfrog/hudson/maven3/classworlds-freestyle.conf");
        this.classworldsConfPath = this.copyClassWorldsFile(ws, resource).getRemote();
        args.addKeyValuePair("-D", "classworlds.conf", this.classworldsConfPath, false);
    }

    private void addMavenOpts(ArgumentListBuilder args, Run<?, ?> build) {
        if (StringUtils.isNotBlank((String)this.getMavenOpts())) {
            String mavenOpts = this.getMavenOpts();
            if (build instanceof AbstractBuild) {
                mavenOpts = Util.replaceMacro((String)this.getMavenOpts(), (Map)((AbstractBuild)build).getBuildVariables());
            }
            args.addTokenized(mavenOpts);
        }
    }

    private FilePath getMavenHome(TaskListener listener, EnvVars env, Launcher launcher) throws IOException, InterruptedException {
        if (StringUtils.isNotEmpty((String)this.mavenName)) {
            Maven.MavenInstallation mi = this.getMaven();
            if (mi == null) {
                listener.error("Couldn't find Maven executable.");
                throw new Run.RunnerAbortedException();
            }
            Node node = ActionableHelper.getNode(launcher);
            mi = mi.forNode(node, listener);
            mi = mi.forEnvironment(env);
            return new FilePath(launcher.getChannel(), mi.getHome());
        }
        if (env.get((Object)MAVEN_HOME) != null) {
            return new FilePath(launcher.getChannel(), (String)env.get((Object)MAVEN_HOME));
        }
        throw new RuntimeException("Couldn't find maven installation");
    }

    private Maven.MavenInstallation getMaven() {
        Maven.MavenInstallation[] installations;
        for (Maven.MavenInstallation i : installations = this.getDescriptor().getInstallations()) {
            if (this.mavenName == null || !this.mavenName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    private String getMavenProjectPath(Run<?, ?> build, FilePath ws) {
        if (build instanceof AbstractBuild) {
            if (StringUtils.isNotBlank((String)this.getRootPom())) {
                return ((AbstractBuild)build).getModuleRoot().getRemote() + File.separatorChar + this.getRootPom().replace("/pom.xml", "");
            }
            return ((AbstractBuild)build).getModuleRoot().getRemote();
        }
        return ws.getRemote();
    }

    private FilePath copyClassWorldsFile(FilePath ws, URL resource) {
        try {
            FilePath remoteClassworlds = ws.createTextTempFile("classworlds", "conf", "");
            remoteClassworlds.copyFrom(resource);
            return remoteClassworlds;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType) || Jenkins.getInstance().getPlugin("jenkins-multijob-plugin") != null && MultiJobProject.class.isAssignableFrom(jobType);
        }

        public String getHelpFile() {
            return "/help/project-config/maven.html";
        }

        public String getDisplayName() {
            return Messages.step_displayName();
        }

        public Maven.MavenInstallation[] getInstallations() {
            return ((Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
        }

        public Maven3Builder newInstance(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
            return (Maven3Builder)((Object)request.bindJSON(this.clazz, formData));
        }
    }
}

