/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;

public class DependenciesDownloaderImpl
implements DependenciesDownloader {
    private ArtifactoryDependenciesClient client;
    private FilePath workspace;
    private Log log;
    private boolean flatDownload = false;

    public DependenciesDownloaderImpl(ArtifactoryDependenciesClient client, FilePath workspace, Log log) {
        this.client = client;
        this.workspace = workspace;
        this.log = log;
    }

    public ArtifactoryDependenciesClient getClient() {
        return this.client;
    }

    public List<Dependency> download(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper((DependenciesDownloader)this, this.log);
        return helper.downloadDependencies(downloadableArtifacts);
    }

    public String getTargetDir(String targetDir, String relativeDir) throws IOException {
        try {
            String downloadFileRelativePath = this.flatDownload && relativeDir.contains("/") ? StringUtils.substringAfterLast((String)relativeDir, (String)"/") : relativeDir;
            FilePath targetDirFile = new FilePath(this.workspace, targetDir).child(downloadFileRelativePath);
            return targetDirFile.absolutize().getRemote();
        }
        catch (InterruptedException e) {
            this.log.warn("Caught interrupted exception: " + e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> saveDownloadedFile(InputStream is, String filePath) throws IOException {
        try {
            FilePath child = this.workspace.child(filePath);
            child.copyFrom(is);
            Map map = (Map)child.act((FilePath.FileCallable)new DownloadFileCallable(this.log));
            return map;
        }
        catch (InterruptedException e) {
            this.log.warn("Caught interrupted exception: " + e.getLocalizedMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return null;
    }

    public boolean isFileExistsLocally(String filePath, String md5, String sha1) throws IOException {
        try {
            boolean isExists;
            FilePath child = this.workspace.child(filePath);
            if (!child.exists()) {
                return false;
            }
            if (child.isDirectory()) {
                return false;
            }
            Map checksumsMap = (Map)child.act((FilePath.FileCallable)new DownloadFileCallable(this.log));
            boolean bl = isExists = checksumsMap != null && StringUtils.isNotBlank((String)md5) && StringUtils.equals((String)md5, (String)((String)checksumsMap.get("md5"))) && StringUtils.isNotBlank((String)sha1) && StringUtils.equals((String)sha1, (String)((String)checksumsMap.get("sha1")));
            if (isExists) {
                return true;
            }
            this.log.info(String.format("Overriding existing in destination file: %s", child));
            return false;
        }
        catch (InterruptedException e) {
            this.log.warn("Caught interrupted exception: " + e.getLocalizedMessage());
            return false;
        }
    }

    public void removeUnusedArtifactsFromLocal(Set<String> allResolvesFiles, Set<String> forDeletionFiles) throws IOException {
        try {
            for (String resolvedFile : forDeletionFiles) {
                List fileSiblings;
                FilePath resolvedFileParent = this.workspace.child(resolvedFile).getParent();
                if (!resolvedFileParent.exists() || (fileSiblings = resolvedFileParent.list()) == null || fileSiblings.isEmpty()) continue;
                for (FilePath sibling : fileSiblings) {
                    String siblingPath = sibling.absolutize().getRemote();
                    if (this.isResolvedOrParentOfResolvedFile(allResolvesFiles, siblingPath)) continue;
                    sibling.deleteRecursive();
                    this.log.info("Deleted unresolved file '" + siblingPath + "'");
                }
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Caught interrupted exception: " + e.getLocalizedMessage());
        }
    }

    public void setFlatDownload(boolean flat) {
        this.flatDownload = flat;
    }

    private boolean isResolvedOrParentOfResolvedFile(Set<String> resolvedFiles, final String path) {
        return Iterables.any(resolvedFiles, (Predicate)new Predicate<String>(){

            public boolean apply(String filePath) {
                return StringUtils.equals((String)filePath, (String)path) || StringUtils.startsWith((String)filePath, (String)path);
            }
        });
    }

    private static class DownloadFileCallable
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private Log log;

        public DownloadFileCallable(Log log) {
            this.log = log;
        }

        public Map<String, String> invoke(File f, VirtualChannel channel) throws IOException {
            try {
                return FileChecksumCalculator.calculateChecksums((File)f, (String[])new String[]{"md5", "sha1"});
            }
            catch (NoSuchAlgorithmException e) {
                this.log.warn("Could not find checksum algorithm: " + e.getLocalizedMessage());
                return null;
            }
        }
    }
}

