/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.action;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.RepositoriesUtils;

public class ArtifactoryProjectAction
implements ProminentProjectAction {
    private final String urlSuffix;
    private final String artifactoryServerName;

    public ArtifactoryProjectAction(String artifactoryServerName, AbstractProject<?, ?> project) {
        this.urlSuffix = this.generateUrlSuffix(project);
        this.artifactoryServerName = artifactoryServerName;
    }

    public ArtifactoryProjectAction(String artifactoryServerName, String buildName) {
        this.urlSuffix = this.generateUrlSuffix(buildName);
        this.artifactoryServerName = artifactoryServerName;
    }

    public String getIconFileName() {
        return "/plugin/artifactory/images/artifactory-icon.png";
    }

    public String getDisplayName() {
        return "Artifactory Build Info";
    }

    public String getUrlName() {
        return RepositoriesUtils.getArtifactoryServer(this.artifactoryServerName, RepositoriesUtils.getArtifactoryServers()).getUrl() + this.urlSuffix;
    }

    private String generateUrlSuffix(AbstractProject<?, ?> project) {
        return this.generateUrlSuffix(ExtractorUtils.sanitizeBuildName(project.getFullName()));
    }

    private String generateUrlSuffix(String buildName) {
        return "/webapp/#/builds/" + Util.rawEncode((String)buildName) + "/";
    }
}

