/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import com.google.common.collect.Lists;
import hudson.ProxyConfiguration;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryBuildInfoClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.VirtualRepository;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.ArtifactoryServerConverter;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryServer
implements Serializable {
    private static final Logger log = Logger.getLogger(ArtifactoryServer.class.getName());
    private static final int DEFAULT_CONNECTION_TIMEOUT = 300;
    private static final int DEFAULT_DEPLOYMENT_THREADS_NUMBER = 3;
    private final String url;
    private final String id;
    private int timeout = 300;
    private boolean bypassProxy;
    private Integer connectionRetry;
    private Integer deploymentThreads;
    private volatile transient List<String> repositories;
    private volatile transient List<VirtualRepository> virtualRepositories;
    @Deprecated
    private Credentials deployerCredentials;
    @Deprecated
    private Credentials resolverCredentials;
    private CredentialsConfig deployerCredentialsConfig;
    private CredentialsConfig resolverCredentialsConfig;

    @DataBoundConstructor
    public ArtifactoryServer(String serverId, String artifactoryUrl, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, int timeout, boolean bypassProxy, Integer connectionRetry, Integer deploymentThreads) {
        this.url = StringUtils.removeEnd((String)artifactoryUrl, (String)"/");
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.timeout = timeout > 0 ? timeout : 300;
        this.bypassProxy = bypassProxy;
        this.id = serverId;
        this.connectionRetry = connectionRetry != null ? connectionRetry : 3;
        this.deploymentThreads = deploymentThreads != null && deploymentThreads > 0 ? deploymentThreads : 3;
    }

    public String getName() {
        return this.id;
    }

    public String getUrl() {
        return this.url != null ? this.url : this.getName();
    }

    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isBypassProxy() {
        return this.bypassProxy;
    }

    public List<Integer> getConnectionRetries() {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            items.add(i);
        }
        return items;
    }

    public int getConnectionRetry() {
        if (this.connectionRetry == null) {
            this.connectionRetry = 3;
        }
        return this.connectionRetry;
    }

    public void setConnectionRetry(int connectionRetry) {
        this.connectionRetry = connectionRetry;
    }

    public List<Integer> getDeploymentsThreads() {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 1; i <= 10; ++i) {
            items.add(i);
        }
        return items;
    }

    public void setDeploymentThreads(int deploymentThreads) {
        this.deploymentThreads = deploymentThreads;
    }

    public int getDeploymentThreads() {
        return this.deploymentThreads == null ? 3 : this.deploymentThreads;
    }

    public List<String> getLocalRepositoryKeys(Credentials credentials) throws IOException {
        try (ArtifactoryBuildInfoClient client = this.createArtifactoryClient(credentials.getUsername(), credentials.getPassword(), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));){
            this.repositories = client.getLocalRepositoriesKeys();
        }
        return this.repositories;
    }

    public List<String> getReleaseRepositoryKeysFirst(DeployerOverrider deployerOverrider, Item item) throws IOException {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        List<String> repositoryKeys = this.getLocalRepositoryKeys(credentialsConfig.getCredentials(item));
        if (repositoryKeys == null || repositoryKeys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collections.sort(repositoryKeys, new RepositoryComparator());
        return repositoryKeys;
    }

    public List<String> getSnapshotRepositoryKeysFirst(DeployerOverrider deployerOverrider, Item item) throws IOException {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        List<String> repositoryKeys = this.getLocalRepositoryKeys(credentialsConfig.getCredentials(item));
        if (repositoryKeys == null || repositoryKeys.isEmpty()) {
            return Lists.newArrayList();
        }
        Collections.sort(repositoryKeys, Collections.reverseOrder(new RepositoryComparator()));
        return repositoryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStagingStrategy(PluginSettings selectedStagingPlugin, String buildName, Item item) throws IOException {
        CredentialsConfig resolvingCredentialsConfig = this.getResolvingCredentialsConfig();
        try (ArtifactoryBuildInfoClient client = this.createArtifactoryClient(resolvingCredentialsConfig.provideUsername(item), resolvingCredentialsConfig.providePassword(item), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));){
            Map map = client.getStagingStrategy(selectedStagingPlugin.getPluginName(), buildName, selectedStagingPlugin.getParamMap());
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualRepository> getVirtualRepositoryKeys(ResolverOverrider resolverOverrider, Item item) {
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(resolverOverrider, this);
        try (ArtifactoryBuildInfoClient client = this.createArtifactoryClient(preferredResolver.provideUsername(item), preferredResolver.providePassword(item), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));){
            this.virtualRepositories = RepositoriesUtils.generateVirtualRepos(client);
        }
        return this.virtualRepositories;
    }

    public boolean isArtifactoryPro(DeployerOverrider deployerOverrider, Item item) {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        try {
            ArtifactoryHttpClient client = new ArtifactoryHttpClient(this.url, credentialsConfig.provideUsername(item), credentialsConfig.providePassword(item), (Log)new NullLog());
            ArtifactoryVersion version = client.getVersion();
            return version.hasAddons();
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, "Could not obtain artifactory version from '" + this.url + "'", e);
            } else {
                log.log(Level.WARNING, "Could not obtain artifactory version from '" + this.url + "': " + e.getMessage());
            }
            return false;
        }
    }

    public List<UserPluginInfo> getStagingUserPluginInfo(DeployerOverrider deployerOverrider, Item item) {
        ArrayList infosToReturn = Lists.newArrayList((Object[])new UserPluginInfo[]{UserPluginInfo.NO_PLUGIN});
        this.gatherUserPluginInfo(infosToReturn, "staging", deployerOverrider, item);
        return infosToReturn;
    }

    public List<UserPluginInfo> getPromotionsUserPluginInfo(DeployerOverrider deployerOverrider, Item item) {
        ArrayList infosToReturn = Lists.newArrayList((Object[])new UserPluginInfo[]{UserPluginInfo.NO_PLUGIN});
        this.gatherUserPluginInfo(infosToReturn, "promotions", deployerOverrider, item);
        return infosToReturn;
    }

    public ArtifactoryBuildInfoClient createArtifactoryClient(String userName, String password, org.jfrog.build.client.ProxyConfiguration proxyConfiguration) {
        return this.createArtifactoryClient(userName, password, proxyConfiguration, (Log)new NullLog());
    }

    public ArtifactoryBuildInfoClient createArtifactoryClient(String userName, String password, org.jfrog.build.client.ProxyConfiguration proxyConfiguration, Log logger) {
        ArtifactoryBuildInfoClientBuilder clientBuilder = this.createArtifactoryClientBuilder(userName, password, proxyConfiguration, logger);
        return clientBuilder.build();
    }

    public ArtifactoryBuildInfoClientBuilder createArtifactoryClientBuilder(String userName, String password, org.jfrog.build.client.ProxyConfiguration proxyConfiguration, Log logger) {
        ArtifactoryBuildInfoClientBuilder clientBuilder = new ArtifactoryBuildInfoClientBuilder();
        ((ArtifactoryBuildInfoClientBuilder)((ArtifactoryBuildInfoClientBuilder)((ArtifactoryBuildInfoClientBuilder)((ArtifactoryBuildInfoClientBuilder)((ArtifactoryBuildInfoClientBuilder)clientBuilder.setArtifactoryUrl(this.url)).setUsername(userName)).setPassword(password)).setLog(logger)).setConnectionRetry(this.getConnectionRetry())).setConnectionTimeout(this.timeout);
        if (!this.bypassProxy) {
            clientBuilder.setProxyConfiguration(proxyConfiguration);
        }
        return clientBuilder;
    }

    private void setRetryParams(ArtifactoryBaseClient client) {
        RepositoriesUtils.setRetryParams(this.getConnectionRetry(), client);
    }

    public static org.jfrog.build.client.ProxyConfiguration createProxyConfiguration(ProxyConfiguration proxy) {
        org.jfrog.build.client.ProxyConfiguration proxyConfiguration = null;
        if (proxy != null) {
            proxyConfiguration = new org.jfrog.build.client.ProxyConfiguration();
            proxyConfiguration.host = proxy.name;
            proxyConfiguration.port = proxy.port;
            proxyConfiguration.username = proxy.getUserName();
            proxyConfiguration.password = proxy.getPassword();
        }
        return proxyConfiguration;
    }

    public ArtifactoryDependenciesClient createArtifactoryDependenciesClient(String userName, String password, org.jfrog.build.client.ProxyConfiguration proxyConfiguration, TaskListener listener) {
        ArtifactoryDependenciesClient client = new ArtifactoryDependenciesClient(this.url, userName, password, (Log)new JenkinsBuildInfoLog(listener));
        client.setConnectionTimeout(this.timeout);
        this.setRetryParams((ArtifactoryBaseClient)client);
        if (!this.bypassProxy && proxyConfiguration != null) {
            client.setProxyConfiguration(proxyConfiguration.host, proxyConfiguration.port, proxyConfiguration.username, proxyConfiguration.password);
        }
        return client;
    }

    public CredentialsConfig getResolvingCredentialsConfig() {
        if (this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided()) {
            return this.getResolverCredentialsConfig();
        }
        if (this.deployerCredentialsConfig != null) {
            return this.getDeployerCredentialsConfig();
        }
        return CredentialsConfig.EMPTY_CREDENTIALS_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherUserPluginInfo(List<UserPluginInfo> infosToReturn, String pluginKey, DeployerOverrider deployerOverrider, Item item) {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        try (ArtifactoryBuildInfoClient client = this.createArtifactoryClient(credentialsConfig.provideUsername(item), credentialsConfig.providePassword(item), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));){
            List stagingUserPluginInfo;
            Map userPluginInfo = client.getUserPluginInfo();
            if (userPluginInfo != null && userPluginInfo.containsKey(pluginKey) && (stagingUserPluginInfo = (List)userPluginInfo.get(pluginKey)) != null) {
                for (Map stagingPluginInfo : stagingUserPluginInfo) {
                    infosToReturn.add(new UserPluginInfo(stagingPluginInfo));
                }
                Collections.sort(infosToReturn, new Comparator<UserPluginInfo>(){

                    @Override
                    public int compare(UserPluginInfo o1, UserPluginInfo o2) {
                        return o1.getPluginName().compareTo(o2.getPluginName());
                    }
                });
            }
        }
    }

    public void setLog(TaskListener listener, ArtifactoryBaseClient client) {
        client.setLog((Log)new JenkinsBuildInfoLog(listener));
    }

    public static final class ConverterImpl
    extends ArtifactoryServerConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    private static class RepositoryComparator
    implements Comparator<String>,
    Serializable {
        private RepositoryComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains("snapshot") && !o2.contains("snapshot")) {
                return 1;
            }
            return -1;
        }
    }
}

