/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.UserPluginInfoParam;
import org.jfrog.hudson.action.ArtifactoryProjectAction;
import org.jfrog.hudson.maven2.ArtifactsDeployer;
import org.jfrog.hudson.maven2.MavenBuildInfoDeployer;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ArtifactoryRedeployPublisher
extends Recorder
implements DeployerOverrider,
BuildInfoAwareConfigurator {
    public final boolean evenIfUnstable;
    private final ServerDetails deployerDetails;
    private final boolean deployArtifacts;
    private final IncludesExcludes artifactDeploymentPatterns;
    private final CredentialsConfig deployerCredentialsConfig;
    private final boolean includeEnvVars;
    private final IncludesExcludes envVarsPatterns;
    private final boolean passIdentifiedDownstream;
    private final boolean discardOldBuilds;
    private final boolean discardBuildArtifacts;
    private final boolean asyncBuildRetention;
    private final String deploymentProperties;
    private final boolean enableIssueTrackerIntegration;
    private final boolean allowPromotionOfNonStagedBuilds;
    private final boolean filterExcludedArtifactsFromBuild;
    private final boolean recordAllDependencies;
    private String defaultPromotionTargetRepository;
    private boolean deployBuildInfo;
    private String aggregationBuildStatus;
    private boolean aggregateBuildIssues;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private ServerDetails details = null;
    @Deprecated
    private final String matrixParams;

    @DataBoundConstructor
    public ArtifactoryRedeployPublisher(ServerDetails details, ServerDetails deployerDetails, boolean deployArtifacts, IncludesExcludes artifactDeploymentPatterns, CredentialsConfig deployerCredentialsConfig, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean deployBuildInfo, boolean evenIfUnstable, boolean discardOldBuilds, boolean passIdentifiedDownstream, boolean discardBuildArtifacts, boolean asyncBuildRetention, String matrixParams, String deploymentProperties, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean recordAllDependencies, boolean allowPromotionOfNonStagedBuilds, String defaultPromotionTargetRepository, boolean filterExcludedArtifactsFromBuild, String customBuildName, boolean overrideBuildName) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails;
        this.deployArtifacts = deployArtifacts;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.evenIfUnstable = evenIfUnstable;
        this.discardOldBuilds = discardOldBuilds;
        this.passIdentifiedDownstream = passIdentifiedDownstream;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.asyncBuildRetention = asyncBuildRetention;
        this.deploymentProperties = deploymentProperties;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.deployBuildInfo = deployBuildInfo;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.recordAllDependencies = recordAllDependencies;
        this.allowPromotionOfNonStagedBuilds = allowPromotionOfNonStagedBuilds;
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    public boolean isPassIdentifiedDownstream() {
        return this.passIdentifiedDownstream;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    public boolean isEvenIfUnstable() {
        return this.evenIfUnstable;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getUrl() : null;
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepositoryKey() : null;
    }

    public String getSnapshotsRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeploySnapshotRepositoryKey() : null;
    }

    public String getUserPluginKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getUserPluginKey() : null;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isAllowPromotionOfNonStagedBuilds() {
        return this.allowPromotionOfNonStagedBuilds;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return this.defaultPromotionTargetRepository;
    }

    public void setDefaultPromotionTargetRepository(String defaultPromotionTargetRepository) {
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
    }

    public boolean isRecordAllDependencies() {
        return this.recordAllDependencies;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    public boolean isApplicable(AbstractBuild build) {
        return !this.isBuildFromM2ReleasePlugin(build);
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        if (this.getDeployerDetails() != null) {
            if (this.isOverrideBuildName()) {
                return new ArtifactoryProjectAction(this.getDeployerDetails().getArtifactoryName(), this.getCustomBuildName());
            }
            return new ArtifactoryProjectAction(this.getDeployerDetails().getArtifactoryName(), project);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseThan(this.getTreshold())) {
            return true;
        }
        if (this.isBuildFromM2ReleasePlugin(build)) {
            listener.getLogger().append("M2 Release build, not uploading artifacts to Artifactory. ");
            return true;
        }
        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(this, (Run)build);
        if (this.isExtractorUsed(build.getEnvironment((TaskListener)listener))) {
            if (this.deployBuildInfo) {
                this.addJobActions(build, buildName);
            }
            return true;
        }
        if (!(build instanceof MavenModuleSetBuild)) {
            listener.getLogger().format("Non maven build type: %s", build.getClass()).println();
            build.setResult(Result.FAILURE);
            return true;
        }
        MavenModuleSetBuild mavenBuild = (MavenModuleSetBuild)build;
        if (this.getArtifactoryServer() == null) {
            listener.getLogger().format("No Artifactory server configured for %s. Please check your configuration.", this.getArtifactoryName()).println();
            build.setResult(Result.FAILURE);
            return true;
        }
        List<MavenAbstractArtifactRecord> mars = this.getArtifactRecordActions(mavenBuild);
        if (mars.isEmpty()) {
            listener.getLogger().println("No artifacts are recorded. Is this a Maven project?");
            build.setResult(Result.FAILURE);
            return true;
        }
        ArtifactoryServer server = this.getArtifactoryServer();
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(this, server);
        server.setLog((TaskListener)listener, (ArtifactoryBaseClient)client);
        try (ArtifactoryBuildInfoClient client = server.createArtifactoryClient(preferredDeployer.provideUsername((Item)((MavenModuleSetBuild)build).getProject()), preferredDeployer.providePassword((Item)((MavenModuleSetBuild)build).getProject()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));){
            this.verifySupportedArtifactoryVersion(client);
            if (this.deployArtifacts) {
                new ArtifactsDeployer(this, client, mavenBuild, listener).deploy();
            }
            if (this.deployBuildInfo) {
                new MavenBuildInfoDeployer((BuildInfoAwareConfigurator)this, client, mavenBuild, (TaskListener)listener).deploy();
                this.addJobActions(build, buildName);
            }
            boolean bl = true;
            return bl;
        }
        build.setResult(Result.FAILURE);
        return true;
    }

    private void addJobActions(AbstractBuild build, String buildName) {
        build.getActions().add(0, new BuildInfoResultAction(this.getArtifactoryUrl(), (Run)build, buildName));
        if (this.isAllowPromotionOfNonStagedBuilds()) {
            build.getActions().add(new UnifiedPromoteBuildAction((Run)build, this));
        }
    }

    private boolean isBuildFromM2ReleasePlugin(AbstractBuild<?, ?> build) {
        List causes = build.getCauses();
        return !causes.isEmpty() && Iterables.any((Iterable)causes, (Predicate)new Predicate<Cause>(){

            public boolean apply(Cause input) {
                return "org.jvnet.hudson.plugins.m2release.ReleaseCause".equals(input.getClass().getName());
            }
        });
    }

    private boolean isM2Build(AbstractBuild<?, ?> build) {
        return build.getClass().getName().contains("MavenModuleSetBuild") && ((MavenModuleSetBuild)build).getMavenVersionUsed().startsWith("2");
    }

    private boolean isExtractorUsed(EnvVars env) {
        return Boolean.parseBoolean((String)env.get((Object)"extractor.used"));
    }

    private void verifySupportedArtifactoryVersion(ArtifactoryBuildInfoClient client) throws Exception {
        client.verifyCompatibleArtifactoryVersion();
    }

    protected List<MavenAbstractArtifactRecord> getArtifactRecordActions(MavenModuleSetBuild build) {
        ArrayList actions = Lists.newArrayList();
        for (MavenBuild moduleBuild : build.getModuleLastBuilds().values()) {
            MavenAbstractArtifactRecord action = (MavenAbstractArtifactRecord)moduleBuild.getAction(MavenAbstractArtifactRecord.class);
            if (action == null) continue;
            actions.add(action);
        }
        return actions;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName(), this.getDescriptor().getArtifactoryServers());
    }

    private Result getTreshold() {
        if (this.evenIfUnstable) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public List<Repository> getReleaseRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeployReleaseRepositoryKey());
    }

    public List<Repository> getSnapshotRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepositoryKey());
    }

    public PluginSettings getSelectedStagingPlugin() throws Exception {
        return this.getDeployerDetails().getStagingPlugin();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private Item item;

        public DescriptorImpl() {
            super(ArtifactoryRedeployPublisher.class);
            this.load();
        }

        private List<Repository> refreshRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig) throws IOException {
            List<String> repositoriesKeys = RepositoriesUtils.getLocalRepositories(artifactoryServer.getUrl(), credentialsConfig, artifactoryServer, this.item);
            List<Repository> releaseRepositories = RepositoriesUtils.createRepositoriesList(repositoriesKeys);
            Collections.sort(releaseRepositories);
            return releaseRepositories;
        }

        private List<PluginSettings> refreshUserPlugins(ArtifactoryServer artifactoryServer, final CredentialsConfig credentialsConfig) {
            List<UserPluginInfo> pluginInfoList = artifactoryServer.getStagingUserPluginInfo(new DeployerOverrider(){

                @Override
                public boolean isOverridingDefaultDeployer() {
                    return credentialsConfig != null && credentialsConfig.isCredentialsProvided();
                }

                @Override
                public Credentials getOverridingDeployerCredentials() {
                    return credentialsConfig.getCredentials(item);
                }

                @Override
                public CredentialsConfig getDeployerCredentialsConfig() {
                    return credentialsConfig;
                }
            }, this.item);
            ArrayList<PluginSettings> list = new ArrayList<PluginSettings>(pluginInfoList.size());
            for (UserPluginInfo p : pluginInfoList) {
                HashMap paramsMap = Maps.newHashMap();
                List<UserPluginInfoParam> params = p.getPluginParams();
                for (UserPluginInfoParam param : params) {
                    paramsMap.put((String)param.getKey(), (String)param.getDefaultValue());
                }
                PluginSettings plugin = new PluginSettings(p.getPluginName(), paramsMap);
                list.add(plugin);
            }
            return list;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            this.item = project;
            return PluginsUtils.fillPluginCredentials(project);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType == MavenModuleSet.class;
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            try {
                ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, this.getArtifactoryServers());
                List<Repository> releaseRepositories = this.refreshRepositories(artifactoryServer, credentialsConfig);
                List<PluginSettings> userPluginKeys = this.refreshUserPlugins(artifactoryServer, credentialsConfig);
                response.setRepositories(releaseRepositories);
                response.setUserPlugins(userPluginKeys);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        public ArtifactoryRedeployPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ArtifactoryRedeployPublisher)req.bindJSON(ArtifactoryRedeployPublisher.class, formData);
        }

        public String getDisplayName() {
            return "Deploy artifacts to Artifactory";
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return RepositoriesUtils.getArtifactoryServers();
        }

        public boolean isJiraPluginEnabled() {
            return Jenkins.getInstance().getPlugin("jira") != null;
        }

        public boolean isUseCredentialsPlugin() {
            return PluginsUtils.isUseCredentialsPlugin();
        }
    }
}

