/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ArtifactoryBuilder
extends GlobalConfiguration {

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalConfiguration> {
        private boolean useCredentialsPlugin;
        private List<ArtifactoryServer> artifactoryServers;

        public DescriptorImpl() {
            super(ArtifactoryBuilder.class);
            this.load();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project, ACL.SYSTEM);
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerId(@QueryParameter String value, @QueryParameter String artifactoryUrl, @QueryParameter String username, @QueryParameter String password, @QueryParameter String credentialsId) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set server ID");
            }
            List<ArtifactoryServer> artifactoryServers = RepositoriesUtils.getArtifactoryServers();
            if (artifactoryServers == null) {
                return FormValidation.ok();
            }
            int countServersByValueAsName = 0;
            for (ArtifactoryServer server : artifactoryServers) {
                if (!server.getName().equals(value) || ++countServersByValueAsName <= 1) continue;
                return FormValidation.error((String)"Duplicated server ID");
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public FormValidation doTestConnection(@QueryParameter(value="artifactoryUrl") String url, @QueryParameter(value="artifactory.timeout") String timeout, @QueryParameter(value="artifactory.bypassProxy") boolean bypassProxy, @QueryParameter(value="useCredentialsPlugin") boolean useLegacyCredentials, @QueryParameter(value="credentialsId") String deployerCredentialsId, @QueryParameter(value="username") String deployerCredentialsUsername, @QueryParameter(value="password") String deployerCredentialsPassword, @QueryParameter(value="connectionRetry") int connectionRetry) throws ServletException {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"Please set a valid Artifactory URL");
            }
            if (connectionRetry < 0) {
                return FormValidation.error((String)"Connection Retries can not be less then 0");
            }
            Credentials credentials = PluginsUtils.credentialsLookup(deployerCredentialsId, null);
            String username = useLegacyCredentials ? credentials.getUsername() : deployerCredentialsUsername;
            String password = useLegacyCredentials ? credentials.getPassword() : deployerCredentialsPassword;
            try (ArtifactoryBuildInfoClient client = StringUtils.isNotBlank((String)username) ? new ArtifactoryBuildInfoClient(url, username, password, (Log)new NullLog()) : new ArtifactoryBuildInfoClient(url, (Log)new NullLog());){
                ArtifactoryVersion version;
                if (!bypassProxy && Jenkins.getInstance().proxy != null) {
                    client.setProxyConfiguration(RepositoriesUtils.createProxyConfiguration(Jenkins.getInstance().proxy));
                }
                if (StringUtils.isNotBlank((String)timeout)) {
                    client.setConnectionTimeout(Integer.parseInt(timeout));
                }
                RepositoriesUtils.setRetryParams(connectionRetry, (ArtifactoryBaseClient)client);
                try {
                    version = client.verifyCompatibleArtifactoryVersion();
                }
                catch (UnsupportedOperationException uoe) {
                    FormValidation formValidation = FormValidation.warning((String)uoe.getMessage());
                    client.close();
                    return formValidation;
                }
                catch (Exception e) {
                    FormValidation formValidation = FormValidation.error((String)e.getMessage());
                    client.close();
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.ok((String)("Found Artifactory " + version.toString()));
                return formValidation;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }

        public String getDisplayName() {
            return "Artifactory Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            boolean useCredentialsPlugin = (Boolean)o.get("useCredentialsPlugin");
            Object servers = o.get("artifactoryServer");
            List artifactoryServers = !JSONNull.getInstance().equals(servers) ? req.bindJSONToList(ArtifactoryServer.class, servers) : null;
            if (!this.isServerIDConfigured(artifactoryServers)) {
                throw new Descriptor.FormException("Please set the Artifactory server ID.", "ServerID");
            }
            if (this.isServerDuplicated(artifactoryServers)) {
                throw new Descriptor.FormException("The Artifactory server ID you have entered is already configured", "Server ID");
            }
            this.setArtifactoryServers(artifactoryServers);
            if (useCredentialsPlugin && !this.useCredentialsPlugin) {
                this.resetJobsCredentials();
                this.resetServersCredentials();
            }
            this.useCredentialsPlugin = useCredentialsPlugin;
            this.save();
            return super.configure(req, o);
        }

        private void resetServersCredentials() {
            for (ArtifactoryServer server : this.artifactoryServers) {
                if (server.getResolverCredentialsConfig() != null) {
                    server.getResolverCredentialsConfig().deleteCredentials();
                }
                if (server.getDeployerCredentialsConfig() == null) continue;
                server.getDeployerCredentialsConfig().deleteCredentials();
            }
        }

        private void resetJobsCredentials() {
            List jobs = Jenkins.getInstance().getAllItems(AbstractProject.class);
            for (AbstractProject job : jobs) {
                DeployerOverrider deployer;
                if (!(job instanceof BuildableItemWithBuildWrappers)) continue;
                ResolverOverrider resolver = ActionableHelper.getResolverOverrider((BuildableItem)job);
                if (resolver != null && resolver.getResolverCredentialsConfig() != null) {
                    resolver.getResolverCredentialsConfig().deleteCredentials();
                }
                if ((deployer = ActionableHelper.getDeployerOverrider((BuildableItem)job)) != null && deployer.getDeployerCredentialsConfig() != null) {
                    deployer.getDeployerCredentialsConfig().deleteCredentials();
                }
                if (resolver == null && deployer == null) continue;
                try {
                    job.save();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return this.artifactoryServers;
        }

        public boolean getUseCredentialsPlugin() {
            return this.useCredentialsPlugin;
        }

        public void setArtifactoryServers(List<ArtifactoryServer> artifactoryServers) {
            this.artifactoryServers = artifactoryServers;
        }

        public void setUseCredentialsPlugin(boolean useCredentialsPlugin) {
            this.useCredentialsPlugin = useCredentialsPlugin;
        }

        private boolean isServerDuplicated(List<ArtifactoryServer> artifactoryServers) {
            HashSet<String> serversNames = new HashSet<String>();
            if (artifactoryServers == null) {
                return false;
            }
            for (ArtifactoryServer server : artifactoryServers) {
                String name = server.getName();
                if (serversNames.contains(name)) {
                    return true;
                }
                serversNames.add(name);
            }
            return false;
        }

        private boolean isServerIDConfigured(List<ArtifactoryServer> artifactoryServers) {
            if (artifactoryServers == null) {
                return true;
            }
            for (ArtifactoryServer server : artifactoryServers) {
                String name = server.getName();
                if (!StringUtils.isBlank((String)name)) continue;
                return false;
            }
            return true;
        }
    }
}

