/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.aquadockerscannerbuildstep;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.UUID;

public class ScannerExecuter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String artifactName, String microScannerToken, String imageName, String notCompliesCmd, String outputFormat, boolean checkonly, boolean caCertificates) {
        try (PrintStream print_stream = null;){
            EnvVars env = build.getEnvironment(listener);
            int passwordIndex = 2;
            String microscannerDockerfilePath = workspace.toString() + "/Dockerfile.microscanner";
            StringBuilder microScannerDockerfileContent = new StringBuilder();
            microScannerDockerfileContent.append("FROM " + imageName + "\n");
            microScannerDockerfileContent.append("ADD https://get.aquasec.com/microscanner .\n");
            microScannerDockerfileContent.append("USER 0\n");
            microScannerDockerfileContent.append("ARG token\n");
            microScannerDockerfileContent.append("RUN chmod +x microscanner && ./microscanner ${token} ").append("json".equalsIgnoreCase(outputFormat) ? "" : "--html ");
            if (checkonly) {
                microScannerDockerfileContent.append("--continue-on-failure ");
            }
            if (!caCertificates) {
                microScannerDockerfileContent.append("--no-verify");
            }
            String microScannerDockerfile = microScannerDockerfileContent.toString();
            FilePath dockerTarget = new FilePath(workspace, "Dockerfile.microscanner");
            try {
                dockerTarget.write(microScannerDockerfile, "UTF-8");
            }
            catch (Exception e) {
                listener.getLogger().println("Failed to save MicroScanner Dockerfile.");
            }
            ArgumentListBuilder args = new ArgumentListBuilder();
            String buildArg = "--build-arg=token=" + microScannerToken;
            UUID uniqueId = UUID.randomUUID();
            String uniqueIdStr = uniqueId.toString().toLowerCase();
            args.add(new String[]{"docker", "build", buildArg, "--no-cache", "-t", "aqua-ms-" + uniqueIdStr});
            args.add(new String[]{"-f", microscannerDockerfilePath, workspace.toString()});
            String outFileName = "out";
            File outFile = new File(build.getRootDir(), outFileName);
            Launcher.ProcStarter ps = launcher.launch();
            ps.cmds(args);
            ps.stdin(null);
            ps.stderr((OutputStream)listener.getLogger());
            print_stream = new PrintStream(outFile, "UTF-8");
            ps.stdout((OutputStream)print_stream);
            ps.quiet(true);
            boolean[] masks = new boolean[ps.cmds().size()];
            masks[passwordIndex] = true;
            ps.masks(masks);
            listener.getLogger().println("Aqua MicroScanner in progress...");
            int exitCode = ps.join();
            FilePath target = new FilePath(workspace, artifactName);
            FilePath latestTarget = new FilePath(workspace, "scanlatest." + ("json".equalsIgnoreCase(outputFormat) ? "json" : "html"));
            FilePath outFilePath = new FilePath(outFile);
            outFilePath.copyTo(target);
            String scanOutput = target.readToString();
            if (exitCode == 1) {
                listener.getLogger().println(scanOutput);
            }
            ScannerExecuter.cleanBuildOutput(scanOutput, target, latestTarget, listener, imageName);
            FilePath targetCss = new FilePath(workspace, "styles.css");
            File cssFile = new File((String)env.get((Object)"JENKINS_HOME") + "/plugins/aqua-microscanner/css/", "styles.css");
            FilePath cssFilePath = new FilePath(cssFile);
            cssFilePath.copyTo(targetCss);
            if (exitCode == 4 && !notCompliesCmd.trim().isEmpty()) {
                ps = launcher.launch();
                args = new ArgumentListBuilder();
                args.add(new String[]{"bash", "-c", notCompliesCmd});
                ps.cmds(args);
                ps.stdin(null);
                ps.stderr((OutputStream)listener.getLogger());
                ps.stdout((OutputStream)listener.getLogger());
                ps.join();
            }
            dockerTarget.delete();
            ps = launcher.launch();
            ps.cmdAsSingleString("docker rmi aqua-ms-" + uniqueIdStr);
            ps.quiet(true);
            ps.join();
            int n = exitCode;
            return n;
        }
    }

    private static boolean cleanBuildOutput(String scanOutput, FilePath target, FilePath latestTarget, TaskListener listener, String title) {
        int htmlStart = scanOutput.indexOf("<!DOCTYPE html>");
        int htmlEnd = scanOutput.lastIndexOf("</html>") + 7;
        if (htmlStart > -1) {
            scanOutput = scanOutput.substring(htmlStart, htmlEnd);
            scanOutput = scanOutput.replace("<h1>Scan Report: </h1>", "<h1>Scan Report: " + title + "</h1>");
        } else {
            int jsonStart = scanOutput.indexOf("\"scan_started\"");
            int jsonEnd = scanOutput.lastIndexOf("}") + 1;
            if (jsonStart > -1) {
                scanOutput = "{\n  " + scanOutput.substring(jsonStart, jsonEnd);
            }
        }
        try {
            latestTarget.write(scanOutput, "UTF-8");
            target.write(scanOutput, "UTF-8");
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to save MicroScanner HTML report.");
        }
        return true;
    }
}

