/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.tuple.Pair;

public class ApprendaRestUtility {
    private String ApprendaSessionToken;
    private Logger logger;

    public ApprendaRestUtility() {
        this.ApprendaSessionToken = "";
        this.logger = LogManager.getLogManager().getLogger("jenkins.plugins.apprenda");
    }

    public ApprendaRestUtility(String token) {
        this.ApprendaSessionToken = token;
        this.logger = LogManager.getLogManager().getLogger("jenkins.plugins.apprenda");
    }

    public Response PostResponseRequest(boolean bypassSSL, String url, String path, JsonObject json) throws Exception {
        try {
            if (this.ApprendaSessionToken.length() > 0) {
                Response response = this.getClient(bypassSSL).target(url).path(path).request(new String[]{"application/json"}).header("ApprendaSessionToken", (Object)this.ApprendaSessionToken).post(Entity.json((Object)json));
                this.logger.log(Level.FINE, "Response: " + response);
                return response;
            }
            Response response = this.getClient(bypassSSL).target(url).path(path).request(new String[]{"application/json"}).post(Entity.json((Object)json));
            this.logger.log(Level.FINE, "Response: " + response);
            return response;
        }
        catch (Exception e) {
            this.logger.severe("Error: " + e.getMessage());
            throw new Exception(e);
        }
    }

    public Response GetResponseRequest(boolean bypassSSL, String url, String path, List<Pair<String, String>> queryParams) throws Exception {
        this.logger.log(Level.INFO, "Starting get response for " + path);
        if (this.ApprendaSessionToken.length() == 0) {
            this.logger.log(Level.SEVERE, "apprenda session token missing, require reauthentication");
            return null;
        }
        this.logger.log(Level.INFO, "debug - bypassSSL: " + bypassSSL);
        this.logger.log(Level.INFO, "debug - url: " + url);
        this.logger.log(Level.INFO, "debug - path: " + path);
        WebTarget target = this.getClient(bypassSSL).target(url).path(path);
        if (queryParams != null) {
            for (Pair<String, String> pair : queryParams) {
                target.queryParam((String)pair.getLeft(), new Object[]{pair.getRight()});
            }
        }
        this.logger.log(Level.INFO, "Executing request.");
        Response response = target.request(new String[]{"application/json"}).header("ApprendaSessionToken", (Object)this.ApprendaSessionToken).get();
        return response;
    }

    public Response PatchApplication(boolean bypassSSL, String url, String path, String stage, InputStream fileInStream) throws Exception {
        try {
            return this.getClient(bypassSSL).target(url).path(path).queryParam("action", new Object[]{"patch"}).queryParam("stage", new Object[]{stage}).request(new String[]{"application/json"}).header("ApprendaSessionToken", (Object)this.ApprendaSessionToken).post(Entity.entity((Object)fileInStream, (String)"application/octet-stream"));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public Response PatchApplication(boolean bypassSSL, String url, String path, String stage, String applicationPackageURL) throws Exception {
        try {
            return this.getClient(bypassSSL).target(url).path(path).queryParam("action", new Object[]{"patch"}).queryParam("stage", new Object[]{stage}).queryParam("archiveUri", new Object[]{applicationPackageURL}).request(new String[]{"application/json"}).header("ApprendaSessionToken", (Object)this.ApprendaSessionToken).post(Entity.json((Object)""));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public Response CreateApplication(boolean bypassSSL, String url, String path, String alias, String name) throws Exception {
        try {
            JSONObject json = new JSONObject();
            json.put("Name", (Object)name);
            json.put("Alias", (Object)alias);
            Client client = this.getClient(bypassSSL);
            WebTarget target = client.target(url).path(path);
            Invocation.Builder builder = target.request(new String[]{"application/json"}).header("ApprendaSessionToken", (Object)this.ApprendaSessionToken);
            this.logger.log(Level.INFO, "Request: " + json);
            return builder.post(Entity.json((Object)json));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(e);
        }
    }

    private Client getClient(boolean bypassSSL) {
        try {
            Client client;
            if (bypassSSL) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
                HostnameVerifier verifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                };
                client = ClientBuilder.newBuilder().sslContext(context).hostnameVerifier(verifier).build();
            } else {
                client = ClientBuilder.newClient();
            }
            return client;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

