/*
 * Decompiled with CFR 0.152.
 */
package com.apprenda.jenkins.plugins.apprenda;

import com.apprenda.jenkins.plugins.apprenda.ApprendaCredentials;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import utils.ApprendaRestUtility;

public class ApprendaClient {
    private final String url;
    private final boolean bypassSSL;
    private String token = null;
    private TaskListener listener;

    public ApprendaClient(String url, boolean bypassSSL, TaskListener listener) {
        this.url = url;
        this.bypassSSL = bypassSSL;
        this.listener = listener;
    }

    public boolean authenticate(ApprendaCredentials credentials) throws Exception {
        try {
            this.listener.getLogger().println("[APPRENDA] Attempting to authenticate to Apprenda with username " + credentials.getUsername() + " and tenant alias " + credentials.getTenant() + ".");
            JsonObject json = Json.createObjectBuilder().add("username", credentials.getUsername()).add("password", Secret.toString((Secret)credentials.getPassword())).add("tenantAlias", credentials.getTenant()).build();
            String AUTH_PATH = "authentication/api/v1/sessions/developer";
            Response response = new ApprendaRestUtility().PostResponseRequest(this.bypassSSL, this.getUrl(), AUTH_PATH, json);
            if (response.getStatus() != 201) {
                this.listener.getLogger().println("[APPRENDA] Authentication Failed.");
                return false;
            }
            JsonObject jsonObject = (JsonObject)response.readEntity(JsonObject.class);
            this.token = jsonObject.getString("apprendaSessionToken");
            return true;
        }
        catch (Exception e) {
            this.listener.getLogger().println("Authentication to Apprenda failed. Ensure that BypassSSL is set to true if you are using self-signed certificates for Apprenda.");
            String fullStackTrace = ExceptionUtils.getFullStackTrace((Throwable)e);
            this.listener.getLogger().println(fullStackTrace);
            this.listener.getLogger().println(e.getLocalizedMessage() + e);
            return false;
        }
    }

    public Boolean newAppVersion(String appAlias, String versionAlias) {
        try {
            JsonObject newVersion = Json.createObjectBuilder().add("Name", versionAlias).add("Alias", versionAlias).add("Description", "Version Auto-generated by Apprenda-Jenkins plugin.").build();
            this.listener.getLogger().println("[APPRENDA] Step 1: Create New Version: " + versionAlias);
            Response createVersion = new ApprendaRestUtility(this.token).PostResponseRequest(this.bypassSSL, this.getUrl(), "developer/api/v1/versions/" + appAlias, newVersion);
            if (createVersion.getStatus() == 201) {
                this.listener.getLogger().println("[APPRENDA] New Version Created");
                return true;
            }
            this.listener.getLogger().println("[APPRENDA] Version was not created. Please check to see if the version is taken, or the application exists. Full response: " + ((JsonObject)createVersion.readEntity(JsonObject.class)).toString());
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean patchApp(String appAlias, String versionAlias, File appFile, String stage, String applicationPackageURL) throws IOException {
        try (InputStream fileInStream = null;){
            this.listener.getLogger().println("[APPRENDA] Starting promotion of application: " + appAlias + " and version: " + versionAlias);
            String VERSION_PATH = "developer/api/v1/versions/";
            Response response = null;
            if (appFile != null) {
                fileInStream = new FileInputStream(appFile);
                this.listener.getLogger().println("[APPRENDA] Starting patching of application using archive: " + appFile.getAbsolutePath());
                response = new ApprendaRestUtility(this.token).PatchApplication(this.bypassSSL, this.getUrl(), VERSION_PATH + appAlias + "/" + versionAlias, stage, fileInStream);
            } else {
                this.listener.getLogger().println("[APPRENDA] Starting patching of application using archive in URI: " + applicationPackageURL);
                response = new ApprendaRestUtility(this.token).PatchApplication(this.bypassSSL, this.getUrl(), VERSION_PATH + appAlias + "/" + versionAlias, stage, applicationPackageURL);
            }
            if (response.getStatus() == 200) {
                this.listener.getLogger().println("[APPRENDA] Promotion complete.");
                Boolean bl = true;
                return bl;
            }
            this.listener.getLogger().println("[APPRENDA] An error occurred during the patching of your application. Error details: " + response.toString());
            Boolean bl = false;
            return bl;
        }
    }

    public Boolean createApp(String appAlias, String appName, File appFile, String stage, String applicationPackageURL) {
        try {
            this.listener.getLogger().println("[APPRENDA] Starting creation of application: " + appAlias);
            String PATH = "developer/api/v1/apps";
            Response response = new ApprendaRestUtility(this.token).CreateApplication(this.bypassSSL, this.getUrl(), PATH, appAlias, appName);
            if (response.getStatus() == 201) {
                this.listener.getLogger().println("[APPRENDA] Creation succesful.");
                return this.patchApp(appAlias, "v1", appFile, stage, applicationPackageURL);
            }
            this.listener.getLogger().println("[APPRENDA] An error occurred during the patching of your application. Here's what I got: " + response.toString());
            return false;
        }
        catch (Exception e) {
            this.listener.getLogger().println(e.getMessage() + e);
            return false;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public JsonArray getAppAliasVersions(String appAlias) throws Exception {
        if (this.token == null) {
            throw new SecurityException("[APPRENDA] Authentication failed previously, no session token exists.");
        }
        Response getVersions = new ApprendaRestUtility(this.token).GetResponseRequest(this.bypassSSL, this.getUrl(), "developer/api/v1/versions/" + appAlias, null);
        if (getVersions.getStatus() == 200) {
            return (JsonArray)getVersions.readEntity(JsonArray.class);
        }
        return null;
    }
}

