/*
 * Decompiled with CFR 0.152.
 */
package com.apprenda.jenkins.plugins.apprenda;

import com.apprenda.jenkins.plugins.apprenda.ApprendaClient;
import com.apprenda.jenkins.plugins.apprenda.ApprendaCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ApprendaBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    public final String credentialsId;
    public final String appAlias;
    public final String appName;
    public final String stage;
    public final String artifactName;
    public final String customPackageDirectory;
    public final String applicationPackageURL;
    public String appAliasEx;
    public String appNameEx;
    public String stageEx;
    public String artifactNameEx;
    public String customPackageDirectoryEx;
    public String applicationPackageURLEx;
    public String advVersionAliasToBeForced;
    public final String prefix;
    public final String archiveUploadMethod;
    public final boolean forceNewVersion;
    public final boolean advIsForcingSpecificVersion;
    public final boolean buildWithParameters;
    private static Logger logger = Logger.getLogger("jenkins.plugins.apprenda");

    @DataBoundConstructor
    public ApprendaBuilder(String appAlias, String appName, String versionAlias, String stage, String artifactName, String credentialsId, String prefix, String advVersionAliasToBeForced, String advancedNewVersionOption, String customPackageDirectory, String applicationPackageURL, String archiveUploadMethod, Boolean buildWithParameters) {
        this.appAlias = appAlias;
        this.appName = appName == null || appName.length() == 0 ? appAlias : appName;
        this.advVersionAliasToBeForced = advVersionAliasToBeForced;
        this.advIsForcingSpecificVersion = advancedNewVersionOption.equals("Option_ForceSpecificVersion");
        this.stage = stage;
        this.artifactName = artifactName;
        this.credentialsId = credentialsId;
        this.prefix = prefix;
        this.forceNewVersion = advancedNewVersionOption.equals("Option_AlwaysNewVersion");
        this.customPackageDirectory = customPackageDirectory;
        this.applicationPackageURL = applicationPackageURL;
        this.archiveUploadMethod = archiveUploadMethod;
        this.buildWithParameters = buildWithParameters;
    }

    public void perform(Run<?, ?> run, final FilePath workspace, Launcher launcher, final TaskListener listener) throws InterruptedException, IOException {
        final ApprendaCredentials credentials = (ApprendaCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(ApprendaCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        if (credentials == null) {
            throw new AbortException("[APPRENDA] ERROR: Please configure Jenkins credentials for Apprenda.");
        }
        final String url = credentials.getUrl();
        final boolean isBypassSSL = credentials.getbypassSSL();
        this.appAliasEx = this.appAlias;
        this.appNameEx = this.appName;
        this.stageEx = this.stage;
        this.artifactNameEx = this.artifactName;
        this.customPackageDirectoryEx = this.customPackageDirectory;
        this.applicationPackageURLEx = this.applicationPackageURL;
        if (this.buildWithParameters) {
            EnvVars envVars = run.getEnvironment(listener);
            String resultData = null;
            resultData = (String)envVars.get((Object)this.appAliasEx);
            if (resultData != null && resultData.length() > 0) {
                listener.getLogger().println("[APPRENDA] Loading appAlias from environment value of '" + resultData + "'");
                this.appAliasEx = resultData;
            }
            if ((resultData = (String)envVars.get((Object)this.appNameEx)) != null && resultData.length() > 0) {
                listener.getLogger().println("[APPRENDA] Loading appName from environment value of '" + resultData + "'");
                this.appNameEx = resultData;
            }
            if ((resultData = (String)envVars.get((Object)"$ApprendaStage")) != null && resultData.length() > 0) {
                if (resultData.equals("Definition") || resultData.equals("Sandbox") || resultData.equals("Published")) {
                    listener.getLogger().println("[APPRENDA] Loading stage from environment value of '" + resultData + "'");
                    this.stageEx = resultData;
                } else {
                    listener.getLogger().println("[APPRENDA] Ignoring the incorrect stage definition in the environment value of '" + resultData + "'");
                }
            }
            if ((resultData = (String)envVars.get((Object)this.customPackageDirectoryEx)) != null && resultData.length() > 0) {
                listener.getLogger().println("[APPRENDA] Loading customPackageDirectory from environment value of '" + resultData + "'");
                this.customPackageDirectoryEx = resultData;
            }
            if ((resultData = (String)envVars.get((Object)this.applicationPackageURLEx)) != null && resultData.length() > 0) {
                listener.getLogger().println("[APPRENDA] Loading applicationPackageURL from environment value of '" + resultData + "'");
                this.applicationPackageURLEx = resultData;
            }
            if ((resultData = (String)envVars.get((Object)this.artifactNameEx)) != null && resultData.length() > 0) {
                listener.getLogger().println("[APPRENDA] Loading artifactName from environment value of '" + resultData + "'");
                this.artifactNameEx = resultData;
            }
        }
        Callable<String, IOException> task = new Callable<String, IOException>(){
            private static final long serialVersionUID = 1L;

            public String call() throws IOException {
                try {
                    listener.getLogger().println("[APPRENDA] Begin build step: Deploying application to Apprenda. Create client against URL " + url + " with bypassSSL set to " + isBypassSSL);
                    ApprendaClient ac = new ApprendaClient(url, isBypassSSL, listener);
                    listener.getLogger().println("[APPRENDA] Authentication starting for " + credentials.getUsername());
                    listener.getLogger().println("[APPRENDA] Tenant Alias: " + credentials.getTenant());
                    ac.authenticate(credentials);
                    JsonArray versions = ac.getAppAliasVersions(ApprendaBuilder.this.appAliasEx);
                    if (ApprendaBuilder.this.stageEx == null || ApprendaBuilder.this.stageEx.length() < 2) {
                        throw new AbortException("[APPRENDA] Please select a Target Stage for the deployment of this application to Apprenda");
                    }
                    File app = null;
                    if (ApprendaBuilder.this.archiveUploadMethod == null || ApprendaBuilder.this.archiveUploadMethod.equals("localUpload")) {
                        app = ApprendaBuilder.this.getFile(workspace, ApprendaBuilder.this.artifactNameEx, ApprendaBuilder.this.customPackageDirectoryEx);
                        ApprendaBuilder.this.applicationPackageURLEx = "";
                    }
                    if (ApprendaBuilder.this.advIsForcingSpecificVersion) {
                        if (ApprendaBuilder.this.advVersionAliasToBeForced == null || ApprendaBuilder.this.advVersionAliasToBeForced.length() < 2) {
                            throw new AbortException("[APPRENDA] When forcing the deployment to a specific version, the complete version should be filled in. Currently set as: " + ApprendaBuilder.this.advVersionAliasToBeForced);
                        }
                        listener.getLogger().println("[APPRENDA] Will attempt to force a specific version: " + ApprendaBuilder.this.advVersionAliasToBeForced);
                    } else {
                        ApprendaBuilder.this.advVersionAliasToBeForced = null;
                    }
                    if (versions == null) {
                        listener.getLogger().println("[APPRENDA] Creating a brand new v1 application for alias " + ApprendaBuilder.this.appAliasEx + " at target stage " + ApprendaBuilder.this.stageEx);
                        if (!ac.createApp(ApprendaBuilder.this.appAliasEx, ApprendaBuilder.this.appNameEx, app, ApprendaBuilder.this.stageEx, ApprendaBuilder.this.applicationPackageURLEx).booleanValue()) {
                            throw new AbortException("[APPRENDA] Apprenda application creation failed");
                        }
                        return null;
                    }
                    String tempNewVersion = ApprendaBuilder.this.detectVersion(versions, ac);
                    listener.getLogger().println("[APPRENDA] Patching application to " + tempNewVersion + " for alias " + ApprendaBuilder.this.appAliasEx + " at target stage " + ApprendaBuilder.this.stageEx);
                    if (!ac.patchApp(ApprendaBuilder.this.appAliasEx, tempNewVersion, app, ApprendaBuilder.this.stageEx, ApprendaBuilder.this.applicationPackageURLEx).booleanValue()) {
                        throw new AbortException("[APPRENDA] Apprenda application patching failed");
                    }
                    return null;
                }
                catch (SecurityException s) {
                    listener.getLogger().println("[APPRENDA] Unable to authenticate: " + s.getMessage());
                    throw new AbortException("[APPRENDA] Unable to authenticate: " + s.getMessage());
                }
                catch (IOException e) {
                    listener.getLogger().println("[APPRENDA] ERROR: IOException: " + e.getMessage());
                    throw new AbortException("[APPRENDA] ERROR: IOException" + e.getMessage());
                }
                catch (InterruptedException e) {
                    listener.getLogger().println("[APPRENDA] ERROR: InterruptedException: " + e.getMessage());
                    throw new AbortException("[APPRENDA] Interrupted" + e.getMessage());
                }
                catch (Exception e) {
                    listener.getLogger().println(e.getMessage());
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    throw new AbortException("Unknown exception: " + e);
                }
            }

            public void checkRoles(RoleChecker arg0) throws SecurityException {
            }
        };
        try {
            if (task != null) {
                launcher.getChannel().call((Callable)task);
            }
        }
        catch (IOException e) {
            listener.getLogger().println(e.getMessage());
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AbortException("[APPRENDA] IO Exception: " + e.getMessage());
        }
        catch (InterruptedException e) {
            listener.getLogger().println(e.getMessage());
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AbortException("[APPRENDA] Interrupted: " + e.getMessage());
        }
    }

    private String detectVersion(JsonArray versions, ApprendaClient ac) {
        String tempNewVersion;
        int versionNumber = 1;
        boolean forcedVersionExists = false;
        Pattern pattern = Pattern.compile("\\d+");
        boolean highestVersionPublished = false;
        for (int i = 0; i < versions.size(); ++i) {
            JsonObject version = versions.getJsonObject(i);
            String alias = version.getString("alias");
            if (this.advVersionAliasToBeForced == null && alias.matches(this.prefix + "\\d+")) {
                Matcher matcher = pattern.matcher(alias);
                matcher.find();
                int temp = Integer.parseInt(alias.substring(matcher.start()));
                String versionStage = version.getString("stage");
                if (temp < versionNumber) continue;
                versionNumber = temp;
                if (versionStage.equals("Published")) {
                    highestVersionPublished = true;
                    continue;
                }
                highestVersionPublished = false;
                continue;
            }
            if (this.advVersionAliasToBeForced == null || !alias.matches(this.advVersionAliasToBeForced)) continue;
            forcedVersionExists = true;
        }
        if (this.advVersionAliasToBeForced != null) {
            if (!forcedVersionExists) {
                ac.newAppVersion(this.appAliasEx, this.advVersionAliasToBeForced);
            }
            tempNewVersion = this.advVersionAliasToBeForced;
        } else if (this.forceNewVersion || highestVersionPublished) {
            tempNewVersion = this.prefix + ++versionNumber;
            ac.newAppVersion(this.appAliasEx, tempNewVersion);
        } else {
            tempNewVersion = this.prefix + versionNumber;
            boolean thisVersionExists = false;
            for (int i = 0; i < versions.size(); ++i) {
                JsonObject version = versions.getJsonObject(i);
                String alias = version.getString("alias");
                if (!alias.matches(tempNewVersion)) continue;
                thisVersionExists = true;
            }
            if (!thisVersionExists) {
                ac.newAppVersion(this.appAliasEx, tempNewVersion);
            }
        }
        return tempNewVersion;
    }

    private File getFile(FilePath workspace, String artifactName, String customWorkingPath) throws IOException, InterruptedException {
        try {
            if (customWorkingPath == null) {
                FilePath appPath = new FilePath(workspace, artifactName);
                return new File(appPath.toURI());
            }
            File workingPath = new File(customWorkingPath);
            if (workingPath.isAbsolute()) {
                return new File(workingPath, artifactName);
            }
            File directory = new File(workspace.toURI());
            File appPath = new File(directory, customWorkingPath);
            return new File(appPath, artifactName);
        }
        catch (IOException e) {
            throw new IOException("IOException occurred getting package for deployment", e);
        }
        catch (InterruptedException e) {
            throw new InterruptedException("InterruptedException thrown while getting package for deployment");
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckAppAlias(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the Application Alias");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the Application Name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPrefix(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the Version Prefix");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy to Apprenda";
        }

        public ListBoxModel doFillStageItems(@QueryParameter String stage) {
            StandardListBoxModel items = new StandardListBoxModel();
            items.withEmptySelection();
            items.add((Object)new ListBoxModel.Option("Published", "published", stage.matches("published")));
            items.add((Object)new ListBoxModel.Option("Sandbox", "sandbox", stage.matches("sandbox")));
            items.add((Object)new ListBoxModel.Option("Definition", "definition", stage.matches("definition")));
            return items;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            StandardListBoxModel list = new StandardListBoxModel();
            list.withEmptySelection();
            list.withMatching(CredentialsMatchers.instanceOf(ApprendaCredentials.class), (Iterable)CredentialsProvider.lookupCredentials(ApprendaCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM));
            return list;
        }
    }
}

