/*
 * Decompiled with CFR 0.152.
 */
package jfullam.vfabric.jenkins.plugin.rest;

import java.util.Iterator;
import jfullam.vfabric.jenkins.plugin.rest.ProvisioningService;
import jfullam.vfabric.jenkins.plugin.rest.ServiceException;
import jfullam.vfabric.jenkins.plugin.rest.ServiceResult;
import jfullam.vfabric.rest.appdir.RestProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;

public class ProvisioningRestService
implements ProvisioningService {
    private RestProvider appDirRestProvider;
    private static final Log log = LogFactory.getLog(RestProvider.class);

    public ServiceResult tearDown(String appName, String profileName) throws ServiceException {
        String deploymentId = this.findDeploymentId(appName, profileName);
        if (deploymentId != null) {
            log.info((Object)("Tearing down deployment with id of " + deploymentId));
            JsonNode jsonResult = this.appDirRestProvider.postTeardown(deploymentId);
            return ServiceResult.parseJson(jsonResult);
        }
        log.info((Object)"Nothing to teardown");
        return new ServiceResult(true, "There was no existing deployment to teardown.");
    }

    public ServiceResult scheduleDeployment(String deploymentProfileId) throws ServiceException {
        log.info((Object)("Scheduling a deployment for profile with id " + deploymentProfileId));
        JsonNode deployRequest = this.appDirRestProvider.getDeployProperties(deploymentProfileId);
        JsonNode result = this.appDirRestProvider.postScheduleDeployment(deploymentProfileId, deployRequest);
        return ServiceResult.parseJson(result);
    }

    private String findDeploymentId(String applicationName, String profileName) throws ServiceException {
        JsonNode jsonDeployments = this.appDirRestProvider.getDeployments();
        Iterator resultsNodes = jsonDeployments.get("results").getElements();
        while (resultsNodes.hasNext()) {
            JsonNode deployment = (JsonNode)resultsNodes.next();
            if (!this.isRunningAndIsAMatch(applicationName, profileName, deployment)) continue;
            return deployment.get("id").asText();
        }
        return null;
    }

    private boolean isRunningAndIsAMatch(String applicationName, String deploymentProfileName, JsonNode deployment) {
        return deployment.get("applicationName").asText().equals(applicationName) && deployment.get("deploymentState").asText().equals("DEPLOYMENT_SUCCESS") && deployment.get("deploymentProfileName").asText().equalsIgnoreCase(deploymentProfileName);
    }

    public RestProvider getRestProvider() {
        return this.appDirRestProvider;
    }

    public void setRestProvider(RestProvider restProvider) {
        this.appDirRestProvider = restProvider;
    }
}

