/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import nl.codecentric.jenkins.appd.rest.types.MetricData;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class RestConnection {
    private static final String REST_SEGMENT_METRIC_DATA = "metric-data";
    private static final String REST_PARAM_METRIC_PATH = "metric-path";
    private static final String REST_PARAM_TIME_RANGE_TYPE = "time-range-type";
    private static final String REST_PARAM_START_TIME = "start-time";
    private static final String REST_PARAM_DURATION_IN_MINS = "duration-in-mins";
    private static final String REST_PARAM_ROLLUP = "rollup";
    private static final String REST_PARAM_OUTPUT = "output";
    private static final String PARAM_TIME_RANGE_TYPE_AFTER_TIME = "AFTER_TIME";
    private static final String PARAM_TIME_RANGE_TYPE_BEFORE_NOW = "BEFORE_NOW";
    private static final String PARAM_DEFAULT_ROLLUP = "false";
    private static final String PARAM_DEFAULT_OUTPUT = "JSON";
    private static final Logger LOG = Logger.getLogger(RestConnection.class.getName());
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final WebResource restResource;

    public RestConnection(String restUri, String username, String password, String applicationName) {
        String parsedUsername = this.parseUsername(username);
        String parsedRestUri = this.parseRestUri(restUri);
        String parsedApplicationName = this.parseApplicationName(applicationName);
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getState().setCredentials(null, null, -1, parsedUsername, password);
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.jsonMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ApacheHttpClient restClient = ApacheHttpClient.create((ClientConfig)config);
        restClient.setFollowRedirects(Boolean.valueOf(true));
        this.restResource = restClient.resource(parsedRestUri + parsedApplicationName);
    }

    public boolean validateConnection() {
        boolean validationResult = false;
        try {
            ClientResponse response = (ClientResponse)this.restResource.path("business-transactions/").queryParam(REST_PARAM_OUTPUT, PARAM_DEFAULT_OUTPUT).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
            if (response.getStatus() == 200) {
                String output = (String)response.getEntity(String.class);
                LOG.fine(String.format("Response from AppDynamics server ==> code: %s | output: %s", response.getStatus(), output));
                validationResult = true;
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Some problem connecting to the AppDynamics REST interface, see stack-trace for more information", e);
        }
        return validationResult;
    }

    public MetricData fetchMetricData(String metricPath, int durationInMinutes) {
        return this.fetchMetricData(metricPath, durationInMinutes, -1L);
    }

    public MetricData fetchMetricData(String metricPath, int durationInMinutes, long buildStartTime) {
        String encodedMetricPath = this.encodeRestSegment(metricPath);
        MultivaluedMapImpl paramMap = new MultivaluedMapImpl();
        paramMap.add((Object)REST_PARAM_METRIC_PATH, (Object)encodedMetricPath);
        if (buildStartTime > 0L) {
            paramMap.add((Object)REST_PARAM_TIME_RANGE_TYPE, (Object)PARAM_TIME_RANGE_TYPE_AFTER_TIME);
            paramMap.add((Object)REST_PARAM_START_TIME, (Object)Long.toString(buildStartTime));
        } else {
            paramMap.add((Object)REST_PARAM_TIME_RANGE_TYPE, (Object)PARAM_TIME_RANGE_TYPE_BEFORE_NOW);
        }
        paramMap.add((Object)REST_PARAM_DURATION_IN_MINS, (Object)Integer.toString(durationInMinutes));
        paramMap.add((Object)REST_PARAM_ROLLUP, (Object)PARAM_DEFAULT_ROLLUP);
        paramMap.add((Object)REST_PARAM_OUTPUT, (Object)PARAM_DEFAULT_OUTPUT);
        MetricData resultData = null;
        try {
            ClientResponse response = (ClientResponse)this.restResource.path(REST_SEGMENT_METRIC_DATA).queryParams((MultivaluedMap)paramMap).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
            if (response.getStatus() == 200) {
                String jsonOutput = (String)response.getEntity(String.class);
                LOG.fine(String.format("Response from AppDynamics server ==> code: %s | output: %s", response.getStatus(), jsonOutput));
                List metricList = (List)this.jsonMapper.readValue(jsonOutput, (TypeReference)new TypeReference<List<MetricData>>(){});
                resultData = (MetricData)metricList.get(0);
                LOG.fine("Successfully fetched metrics for path: " + resultData.getMetricPath());
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, String.format("Some problem fetching metrics %s from the AppDynamics REST interface.%n\tsee stack-trace for more information", metricPath), e);
        }
        return resultData;
    }

    public static boolean validateRestUri(String restUri) {
        if (RestConnection.isFieldEmpty(restUri)) {
            return false;
        }
        return restUri.startsWith("http://") || restUri.startsWith("https://");
    }

    public static boolean validateApplicationName(String applicationName) {
        return !RestConnection.isFieldEmpty(applicationName);
    }

    public static boolean validateUsername(String username) {
        return !RestConnection.isFieldEmpty(username);
    }

    public static boolean validatePassword(String password) {
        return !RestConnection.isFieldEmpty(password);
    }

    private String parseUsername(String username) {
        String parsedUsername = username;
        if (!username.contains("@")) {
            parsedUsername = parsedUsername + "@customer1";
        }
        LOG.fine("Parsed username: " + parsedUsername);
        return parsedUsername;
    }

    private String parseRestUri(String restUri) {
        String[] uriOrderedSegments;
        StringBuilder parsedRestUri = new StringBuilder(this.parseRestSegment(restUri));
        for (String segment : uriOrderedSegments = new String[]{"controller", "rest", "applications"}) {
            if (restUri.contains(segment)) continue;
            parsedRestUri.append(segment + "/");
        }
        LOG.fine("Parsed REST uri: " + parsedRestUri.toString());
        return parsedRestUri.toString();
    }

    private String parseApplicationName(String applicationName) {
        String parsedApplicationName = this.encodeRestSegment(applicationName);
        LOG.fine("Parsed Application Name: " + parsedApplicationName);
        return this.parseRestSegment(parsedApplicationName);
    }

    private String encodeRestSegment(String restSegment) {
        String encodedSegment;
        try {
            encodedSegment = URLEncoder.encode(restSegment, "UTF-8");
            encodedSegment = encodedSegment.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            encodedSegment = restSegment;
        }
        return encodedSegment;
    }

    private String parseRestSegment(String restSegment) {
        String parsedSegment = restSegment;
        if (!restSegment.endsWith("/")) {
            parsedSegment = parsedSegment + "/";
        }
        return parsedSegment;
    }

    private static boolean isFieldEmpty(String field) {
        if (field == null || field.isEmpty()) {
            return true;
        }
        String trimmedField = field.trim();
        return trimmedField.length() == 0;
    }
}

