/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.net.URLEncoder;
import nl.codecentric.jenkins.appd.AppDynamicsBuildAction;
import nl.codecentric.jenkins.appd.AppDynamicsReport;
import nl.codecentric.jenkins.appd.rest.types.MetricData;
import nl.codecentric.jenkins.appd.rest.types.MetricValues;
import nl.codecentric.jenkins.appd.util.LocalMessages;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BuildActionResultsDisplay
implements ModelObject {
    private transient AppDynamicsBuildAction buildAction;
    private static AbstractBuild<?, ?> currentBuild = null;
    private AppDynamicsReport currentReport;

    BuildActionResultsDisplay(AppDynamicsBuildAction buildAction, TaskListener listener) throws IOException {
        this.buildAction = buildAction;
        this.currentReport = this.buildAction.getAppDynamicsReport();
        this.currentReport.setBuildAction(buildAction);
        this.addPreviousBuildReportToExistingReport();
    }

    public String getDisplayName() {
        return LocalMessages.REPORT_DISPLAYNAME.toString();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    public AppDynamicsReport getAppDynamicsReport() {
        return this.currentReport;
    }

    public String getEncodedString(String str) {
        String encodedStr;
        try {
            encodedStr = URLEncoder.encode(str, "UTF8");
        }
        catch (Exception e) {
            return str;
        }
        return encodedStr;
    }

    private void addPreviousBuildReportToExistingReport() {
        if (currentBuild == null) {
            currentBuild = this.getBuild();
        } else if (currentBuild != this.getBuild()) {
            currentBuild = null;
            return;
        }
        AbstractBuild previousBuild = this.getBuild().getPreviousBuild();
        if (previousBuild == null) {
            return;
        }
        AppDynamicsBuildAction previousPerformanceAction = (AppDynamicsBuildAction)previousBuild.getAction(AppDynamicsBuildAction.class);
        if (previousPerformanceAction == null) {
            return;
        }
        BuildActionResultsDisplay previousBuildActionResults = previousPerformanceAction.getBuildActionResultsDisplay();
        if (previousBuildActionResults == null) {
            return;
        }
        AppDynamicsReport lastReport = previousBuildActionResults.getAppDynamicsReport();
        this.getAppDynamicsReport().setLastBuildReport(lastReport);
    }

    public void doSummarizerGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        final String metricKey = request.getParameter("metricDataKey");
        final MetricData metricData = this.currentReport.getMetricByKey(metricKey);
        GraphImpl graph = new GraphImpl(metricKey, metricData.getFrequency()){

            @Override
            protected DataSetBuilder<String, Integer> createDataSet() {
                DataSetBuilder dataSetBuilder = new DataSetBuilder();
                int i = 1;
                for (MetricValues value : metricData.getMetricValues()) {
                    dataSetBuilder.add((Number)value.getValue(), (Comparable)((Object)metricKey), (Comparable)Integer.valueOf(i++));
                }
                return dataSetBuilder;
            }
        };
        graph.doPng(request, response);
    }

    private abstract class GraphImpl
    extends Graph {
        private final String graphTitle;
        private final String xLabel;

        protected GraphImpl(String metricKey, String frequency) {
            super(-1L, 400, 300);
            this.graphTitle = this.stripTitle(metricKey);
            this.xLabel = "Time in " + frequency;
        }

        private String stripTitle(String metricKey) {
            return metricKey.substring(metricKey.lastIndexOf("|") + 1);
        }

        protected abstract DataSetBuilder<String, Integer> createDataSet();

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.createDataSet().build();
            JFreeChart chart = ChartFactory.createLineChart((String)this.graphTitle, (String)this.xLabel, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            return chart;
        }
    }
}

