/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.RunList;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import nl.codecentric.jenkins.appd.AppDynamicsBuildAction;
import nl.codecentric.jenkins.appd.AppDynamicsDataCollector;
import nl.codecentric.jenkins.appd.AppDynamicsProjectAction;
import nl.codecentric.jenkins.appd.AppDynamicsReport;
import nl.codecentric.jenkins.appd.rest.RestConnection;
import nl.codecentric.jenkins.appd.util.LocalMessages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AppDynamicsResultsPublisher
extends Recorder {
    private static final String DEFAULT_USERNAME = "username@customer1";
    private static final String DEFAULT_THRESHOLD_METRIC = "Overall Application Performance|Average Response Time (ms)";
    private static final String DEFAULT_CUSTOM_METRIC_PATH = "Overall Application Performance|Stall Count";
    private static final int DEFAULT_THRESHOLD_UNSTABLE = 80;
    private static final int DEFAULT_THRESHOLD_FAILED = 65;
    private static final int DEFAULT_MINIMUM_MEASURE_TIME_MINUTES = 10;
    private static final String CUSTOM_METRIC_PATH = "Custom metric path";
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String appdynamicsRestUri = "";
    private String username = "";
    private String password = "";
    private String applicationName = "";
    private String thresholdMetric = "Overall Application Performance|Average Response Time (ms)";
    private String customMetricPath = "Overall Application Performance|Stall Count";
    private Boolean lowerIsBetter = true;
    private Integer minimumMeasureTimeInMinutes = 10;
    private Integer performanceFailedThreshold = 65;
    private Integer performanceUnstableThreshold = 80;

    @DataBoundConstructor
    public AppDynamicsResultsPublisher(String appdynamicsRestUri, String username, String password, String applicationName, String thresholdMetric, String customMetricPath, Boolean lowerIsBetter, Integer minimumMeasureTimeInMinutes, Integer performanceFailedThreshold, Integer performanceUnstableThreshold) {
        this.setAppdynamicsRestUri(appdynamicsRestUri);
        this.setUsername(username);
        this.setPassword(password);
        this.setApplicationName(applicationName);
        this.setThresholdMetric(thresholdMetric);
        this.setCustomMetricPath(customMetricPath);
        this.setLowerIsBetter(lowerIsBetter);
        this.setMinimumMeasureTimeInMinutes(minimumMeasureTimeInMinutes);
        this.setPerformanceFailedThreshold(performanceFailedThreshold);
        this.setPerformanceUnstableThreshold(performanceUnstableThreshold);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        String selectedMetric = CUSTOM_METRIC_PATH.equals(this.thresholdMetric) ? this.customMetricPath : this.thresholdMetric;
        return new AppDynamicsProjectAction(project, selectedMetric, AppDynamicsDataCollector.getMergedMetricPaths(this.customMetricPath, true));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="No idea why FindBugs is expecting NPE, can safely ignore")
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result result;
        PrintStream logger = listener.getLogger();
        RestConnection connection = new RestConnection(this.appdynamicsRestUri, this.username, this.password, this.applicationName);
        logger.println("Verify connection to AppDynamics REST interface ...");
        if (!connection.validateConnection()) {
            logger.println("Connection to AppDynamics REST interface unsuccessful, cannot proceed with this build step");
            if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                build.setResult(Result.FAILURE);
            }
            return true;
        }
        logger.println("Connection successful, continue to fetch measurements from AppDynamics Controller ...");
        AppDynamicsDataCollector dataCollector = new AppDynamicsDataCollector(connection, build, logger, this.customMetricPath, this.minimumMeasureTimeInMinutes);
        AppDynamicsReport report = dataCollector.createReportFromMeasurements();
        AppDynamicsBuildAction buildAction = new AppDynamicsBuildAction(build, report);
        build.addAction((Action)buildAction);
        String selectedMetric = CUSTOM_METRIC_PATH.equals(this.thresholdMetric) ? this.customMetricPath : this.thresholdMetric;
        logger.println("Ready building AppDynamics report");
        logger.println("Verifying for improving or degrading performance, main metric: " + selectedMetric + " where lower is better = " + this.lowerIsBetter);
        try {
            report.getMetricByKey(selectedMetric);
        }
        catch (Exception e) {
            logger.println("Unable to fetch (threshold) metric to determine if build is degrading. Aborting... Exception:\n\t--> " + e.getMessage());
            if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                build.setResult(Result.FAILURE);
            }
            return true;
        }
        if (this.performanceUnstableThreshold >= 0 && this.performanceUnstableThreshold <= 100) {
            logger.println("Performance degradation greater or equal than " + this.performanceUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            logger.println("Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
        }
        if (this.performanceFailedThreshold >= 0 && this.performanceFailedThreshold <= 100) {
            logger.println("Performance degradation greater or equal than " + this.performanceFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase());
        } else {
            logger.println("Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
        }
        List<AppDynamicsReport> previousReportList = this.getListOfPreviousReports(build, report.getTimestamp());
        logger.println("Number of old reports located for average: " + previousReportList.size());
        double averageOverTime = AppDynamicsResultsPublisher.calculateAverageBasedOnPreviousReports(previousReportList, selectedMetric);
        logger.println("Calculated average from previous reports: " + averageOverTime);
        double currentReportAverage = report.getAverageForMetric(selectedMetric);
        logger.println("Current report average: " + currentReportAverage);
        double performanceAsPercentageOfAverage = this.lowerIsBetter != false ? averageOverTime / currentReportAverage * 100.0 : currentReportAverage / averageOverTime * 100.0;
        logger.println("Current average as percentage of total average: " + performanceAsPercentageOfAverage + "%");
        if (this.performanceFailedThreshold >= 0 && performanceAsPercentageOfAverage - (double)this.performanceFailedThreshold.intValue() < 0.0) {
            build.setResult(Result.FAILURE);
        } else if (this.performanceUnstableThreshold >= 0 && performanceAsPercentageOfAverage - (double)this.performanceUnstableThreshold.intValue() < 0.0 && (result = Result.UNSTABLE).isWorseThan(build.getResult())) {
            build.setResult(result);
        }
        logger.println("Metric: " + selectedMetric + " reported performance compared to average of " + performanceAsPercentageOfAverage + "% . Build status is: " + build.getResult());
        return true;
    }

    private static double calculateAverageBasedOnPreviousReports(List<AppDynamicsReport> reports, String metricPath) {
        double calculatedSum = 0.0;
        int numberOfMeasurements = 0;
        for (AppDynamicsReport report : reports) {
            double value = report.getAverageForMetric(metricPath);
            if (!(value >= 0.0)) continue;
            calculatedSum += value;
            ++numberOfMeasurements;
        }
        double result = -1.0;
        if (numberOfMeasurements > 0) {
            result = calculatedSum / (double)numberOfMeasurements;
        }
        return result;
    }

    private List<AppDynamicsReport> getListOfPreviousReports(AbstractBuild<?, ?> build, long currentTimestamp) {
        ArrayList<AppDynamicsReport> previousReports = new ArrayList<AppDynamicsReport>();
        RunList builds = build.getProject().getBuilds();
        for (AbstractBuild currentBuild : builds) {
            AppDynamicsReport report;
            AppDynamicsBuildAction performanceBuildAction = (AppDynamicsBuildAction)currentBuild.getAction(AppDynamicsBuildAction.class);
            if (performanceBuildAction == null || (report = performanceBuildAction.getBuildActionResultsDisplay().getAppDynamicsReport()) == null || report.getTimestamp() == currentTimestamp && builds.size() != 1) continue;
            previousReports.add(report);
        }
        return previousReports;
    }

    public String getAppdynamicsRestUri() {
        return this.appdynamicsRestUri;
    }

    public void setAppdynamicsRestUri(String appdynamicsRestUri) {
        this.appdynamicsRestUri = appdynamicsRestUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getThresholdMetric() {
        return this.thresholdMetric;
    }

    public void setThresholdMetric(String thresholdMetric) {
        this.thresholdMetric = thresholdMetric == null || thresholdMetric.isEmpty() ? DEFAULT_THRESHOLD_METRIC : thresholdMetric;
    }

    public String getCustomMetricPath() {
        return this.customMetricPath;
    }

    public void setCustomMetricPath(String customMetricPath) {
        this.customMetricPath = customMetricPath == null || customMetricPath.isEmpty() ? DEFAULT_CUSTOM_METRIC_PATH : customMetricPath;
    }

    public Boolean getLowerIsBetter() {
        return this.lowerIsBetter;
    }

    public void setLowerIsBetter(Boolean lowerIsBetter) {
        this.lowerIsBetter = lowerIsBetter;
    }

    public Integer getMinimumMeasureTimeInMinutes() {
        return this.minimumMeasureTimeInMinutes;
    }

    public void setMinimumMeasureTimeInMinutes(Integer minimumMeasureTimeInMinutes) {
        this.minimumMeasureTimeInMinutes = Math.max(10, Math.min(minimumMeasureTimeInMinutes, 1440));
    }

    public Integer getPerformanceFailedThreshold() {
        return this.performanceFailedThreshold;
    }

    public void setPerformanceFailedThreshold(Integer performanceFailedThreshold) {
        this.performanceFailedThreshold = Math.max(0, Math.min(performanceFailedThreshold, 100));
    }

    public Integer getPerformanceUnstableThreshold() {
        return this.performanceUnstableThreshold;
    }

    public void setPerformanceUnstableThreshold(Integer performanceUnstableThreshold) {
        this.performanceUnstableThreshold = Math.max(0, Math.min(performanceUnstableThreshold, 100));
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return LocalMessages.PUBLISHER_DISPLAYNAME.toString();
        }

        public String getHelpFile() {
            return "/plugin/appdynamics-dashboard/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDefaultUsername() {
            return AppDynamicsResultsPublisher.DEFAULT_USERNAME;
        }

        public String getDefaultCustomMetricPath() {
            return AppDynamicsResultsPublisher.DEFAULT_CUSTOM_METRIC_PATH;
        }

        public int getDefaultMinimumMeasureTimeInMinutes() {
            return 10;
        }

        public int getDefaultUnstableThreshold() {
            return 80;
        }

        public int getDefaultFailedThreshold() {
            return 65;
        }

        public ListBoxModel doFillThresholdMetricItems() {
            ListBoxModel model = new ListBoxModel();
            for (String value : AppDynamicsDataCollector.getStaticMetricPaths()) {
                model.add(value);
            }
            model.add(AppDynamicsResultsPublisher.CUSTOM_METRIC_PATH);
            return model;
        }

        public FormValidation doCheckAppdynamicsRestUri(@QueryParameter String appdynamicsRestUri) {
            FormValidation validationResult = RestConnection.validateRestUri(appdynamicsRestUri) ? FormValidation.ok() : FormValidation.error((String)"AppDynamics REST uri is not valid, cannot be empty and has to start with 'http://' or 'https://'");
            return validationResult;
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            FormValidation validationResult = RestConnection.validateUsername(username) ? FormValidation.ok() : FormValidation.error((String)"Username for REST interface cannot be empty");
            return validationResult;
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            FormValidation validationResult = RestConnection.validatePassword(password) ? FormValidation.ok() : FormValidation.error((String)"Password for REST interface cannot be empty");
            return validationResult;
        }

        public FormValidation doCheckApplicationName(@QueryParameter String applicationName) {
            FormValidation validationResult = RestConnection.validateApplicationName(applicationName) ? FormValidation.ok() : FormValidation.error((String)"AppDynamics application name cannot be empty");
            return validationResult;
        }

        public FormValidation doTestAppDynamicsConnection(@QueryParameter(value="appdynamicsRestUri") String appdynamicsRestUri, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="applicationName") String applicationName) {
            RestConnection connection = new RestConnection(appdynamicsRestUri, username, password, applicationName);
            FormValidation validationResult = connection.validateConnection() ? FormValidation.ok((String)"Connection successful") : FormValidation.warning((String)"Connection with AppDynamics RESTful interface could not be established");
            return validationResult;
        }
    }
}

