/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.RunList;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import nl.codecentric.jenkins.appd.AppDynamicsBuildAction;
import nl.codecentric.jenkins.appd.AppDynamicsReport;
import nl.codecentric.jenkins.appd.util.LocalMessages;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class AppDynamicsProjectAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(AppDynamicsProjectAction.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String PLUGIN_NAME = "appdynamics-dashboard";
    private final AbstractProject<?, ?> project;
    private final String mainMetricKey;
    private final String[] allMetricKeys;

    public AppDynamicsProjectAction(AbstractProject project, String mainMetricKey, String[] allMetricKeys) {
        this.project = project;
        this.mainMetricKey = mainMetricKey;
        this.allMetricKeys = (String[])allMetricKeys.clone();
    }

    public String getDisplayName() {
        return LocalMessages.PROJECTACTION_DISPLAYNAME.toString();
    }

    public String getUrlName() {
        return PLUGIN_NAME;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean isTrendVisibleOnProjectDashboard() {
        return this.getExistingReportsList().size() >= 1;
    }

    public List<String> getAvailableMetricKeys() {
        return Arrays.asList(this.allMetricKeys);
    }

    public void doSummarizerGraphMainMetric(StaplerRequest request, StaplerResponse response) throws IOException {
        final Map<ChartUtil.NumberOnlyBuildLabel, Double> averagesFromReports = this.getAveragesFromAllReports(this.getExistingReportsList(), this.mainMetricKey);
        GraphImpl graph = new GraphImpl(this.mainMetricKey + " Overall Graph"){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet() {
                DataSetBuilder dataSetBuilder = new DataSetBuilder();
                for (Map.Entry entry : averagesFromReports.entrySet()) {
                    dataSetBuilder.add((Number)entry.getValue(), (Comparable)((Object)AppDynamicsProjectAction.this.mainMetricKey), (Comparable)entry.getKey());
                }
                return dataSetBuilder;
            }
        };
        graph.doPng(request, response);
    }

    public void doSummarizerGraphForMetric(StaplerRequest request, StaplerResponse response) throws IOException {
        final String metricKey = request.getParameter("metricDataKey");
        final Map<ChartUtil.NumberOnlyBuildLabel, Double> averagesFromReports = this.getAveragesFromAllReports(this.getExistingReportsList(), metricKey);
        GraphImpl graph = new GraphImpl(metricKey + " Overall Graph"){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet() {
                DataSetBuilder dataSetBuilder = new DataSetBuilder();
                for (Map.Entry entry : averagesFromReports.entrySet()) {
                    dataSetBuilder.add((Number)entry.getValue(), (Comparable)((Object)metricKey), (Comparable)entry.getKey());
                }
                return dataSetBuilder;
            }
        };
        graph.doPng(request, response);
    }

    private List<AppDynamicsReport> getExistingReportsList() {
        ArrayList<AppDynamicsReport> adReportList = new ArrayList<AppDynamicsReport>();
        if (null == this.project) {
            return adReportList;
        }
        RunList builds = this.project.getBuilds();
        for (AbstractBuild currentBuild : builds) {
            AppDynamicsReport report;
            AppDynamicsBuildAction performanceBuildAction = (AppDynamicsBuildAction)currentBuild.getAction(AppDynamicsBuildAction.class);
            if (performanceBuildAction == null || (report = performanceBuildAction.getBuildActionResultsDisplay().getAppDynamicsReport()) == null) continue;
            adReportList.add(report);
        }
        return adReportList;
    }

    private Map<ChartUtil.NumberOnlyBuildLabel, Double> getAveragesFromAllReports(List<AppDynamicsReport> reports, String metricKey) {
        TreeMap<ChartUtil.NumberOnlyBuildLabel, Double> averages = new TreeMap<ChartUtil.NumberOnlyBuildLabel, Double>();
        for (AppDynamicsReport report : reports) {
            double value = -1.0;
            try {
                value = report.getAverageForMetric(metricKey);
            }
            catch (IllegalArgumentException e) {
                LOGGER.info(String.format("Build %s does not contain metric %s, silently skipping", report.getName(), metricKey));
            }
            if (!(value >= 0.0)) continue;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(report.getBuild());
            averages.put(label, value);
        }
        return averages;
    }

    private abstract class GraphImpl
    extends Graph {
        private final String graphTitle;

        protected GraphImpl(String metricKey) {
            super(-1L, 400, 300);
            this.graphTitle = this.stripTitle(metricKey);
        }

        private String stripTitle(String metricKey) {
            return metricKey.substring(metricKey.lastIndexOf("|") + 1);
        }

        protected abstract DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet();

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.createDataSet().build();
            JFreeChart chart = ChartFactory.createLineChart((String)this.graphTitle, (String)"Build Number #", null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            return chart;
        }
    }
}

