/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.codecentric.jenkins.appd.AppDynamicsReport;
import nl.codecentric.jenkins.appd.BuildActionResultsDisplay;
import nl.codecentric.jenkins.appd.util.LocalMessages;
import org.kohsuke.stapler.StaplerProxy;

public class AppDynamicsBuildAction
implements Action,
StaplerProxy {
    private final AbstractBuild<?, ?> build;
    private final AppDynamicsReport report;
    private transient WeakReference<BuildActionResultsDisplay> buildActionResultsDisplay;
    private static final transient Logger logger = Logger.getLogger(AppDynamicsBuildAction.class.getName());

    public AppDynamicsBuildAction(AbstractBuild<?, ?> build, AppDynamicsReport report) {
        this.build = build;
        this.report = report;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return LocalMessages.BUILDACTION_DISPLAYNAME.toString();
    }

    public String getUrlName() {
        return "appdynamics-dashboard";
    }

    public BuildActionResultsDisplay getTarget() {
        return this.getBuildActionResultsDisplay();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public AppDynamicsReport getAppDynamicsReport() {
        return this.report;
    }

    public BuildActionResultsDisplay getBuildActionResultsDisplay() {
        BuildActionResultsDisplay buildDisplay = null;
        WeakReference<BuildActionResultsDisplay> wr = this.buildActionResultsDisplay;
        if (wr != null && (buildDisplay = (BuildActionResultsDisplay)wr.get()) != null) {
            return buildDisplay;
        }
        try {
            buildDisplay = new BuildActionResultsDisplay(this, (TaskListener)StreamTaskListener.fromStdout());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error creating new BuildActionResultsDisplay()", e);
        }
        this.buildActionResultsDisplay = new WeakReference<BuildActionResultsDisplay>(buildDisplay);
        return buildDisplay;
    }

    public void setBuildActionResultsDisplay(WeakReference<BuildActionResultsDisplay> buildActionResultsDisplay) {
        this.buildActionResultsDisplay = buildActionResultsDisplay;
    }
}

