/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector.util;

import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.appdetector.AppLabelAtom;
import org.jenkinsci.plugins.appdetector.AppLabelSet;
import org.zeroturnaround.exec.ProcessExecutor;

public class Utils {
    public static String expandVariables(Map<String, String> buildVars, String token) {
        String result;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (buildVars != null) {
            vars.putAll(buildVars);
        }
        if ((result = Util.fixEmptyAndTrim((String)token)) != null) {
            result = Util.replaceMacro((String)result, vars);
        }
        return Util.fixEmptyAndTrim((String)result);
    }

    public static Computer[] getAllComputers() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return new Computer[0];
        }
        return jenkins.getComputers();
    }

    public static AppLabelSet getApplicationLabels() {
        Computer[] allComputers;
        AppLabelSet applicationLabels = new AppLabelSet();
        for (Computer computer : allComputers = Utils.getAllComputers()) {
            Node node = computer.getNode();
            if (node == null) continue;
            applicationLabels.addAll(Utils.getApplicationLabels(node));
        }
        return applicationLabels;
    }

    public static AppLabelSet getApplicationLabels(Node node) {
        AppLabelSet applicationLabels = new AppLabelSet();
        Set allLabels = node.getAssignedLabels();
        for (LabelAtom label : allLabels) {
            if (!(label instanceof AppLabelAtom)) continue;
            applicationLabels.add((AppLabelAtom)label);
        }
        return applicationLabels;
    }

    public static String runExternalCommand(String ... command) throws Exception {
        String output = new ProcessExecutor().command(command).readOutput(true).execute().outputUTF8();
        if (output == null) {
            output = "";
        }
        return output;
    }
}

