/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector.task;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Scanner;
import jenkins.security.MasterToSlaveCallable;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.jenkinsci.plugins.appdetector.AppDetectionSetting;
import org.jenkinsci.plugins.appdetector.util.Utils;

public class AppDetectionTask
extends MasterToSlaveCallable<String, Exception> {
    private String appName;
    private String scriptString;
    private boolean onLinux;
    private boolean onOsx;
    private boolean onWindows;

    public AppDetectionTask(AppDetectionSetting setting) {
        this.appName = setting.getAppName();
        this.scriptString = setting.getScript();
        this.onLinux = setting.getOnLinux();
        this.onOsx = setting.getOnOsx();
        this.onWindows = setting.getOnWindows();
    }

    public String call() throws Exception {
        String result = "[]";
        String platform = this.getPlatform();
        if ("osx".equals(platform) ? !this.onOsx : ("linux".equals(platform) ? !this.onLinux : !this.onWindows)) {
            return result;
        }
        String templateString = this.loadTemplateFile();
        StringWriter writer = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("platform", (Object)platform);
        context.put("scriptBody", (Object)this.scriptString);
        Velocity.evaluate((Context)context, (Writer)writer, (String)"", (String)templateString);
        GroovyShell shell = new GroovyShell(((Object)((Object)this)).getClass().getClassLoader());
        Script script = shell.parse(writer.toString());
        result = (String)script.run();
        return result;
    }

    private String getPlatform() {
        try {
            String uname = Utils.runExternalCommand("uname").replace("\n", "");
            if ("Darwin".equals(uname)) {
                return "osx";
            }
            return "linux";
        }
        catch (Exception e) {
            return "windows";
        }
    }

    private String loadTemplateFile() throws Exception {
        URL templateUrl = AppDetectionTask.class.getResource("template.groovy.vm");
        InputStream in = templateUrl.openConnection().getInputStream();
        String templateString = new Scanner(in, "UTF-8").useDelimiter("\\A").next();
        return templateString;
    }
}

