/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jenkinsci.plugins.appdetector.AppLabelAtom;

public class AppLabelSet
extends HashSet<AppLabelAtom> {
    public Set<String> getAppNames() {
        TreeSet<String> appNames = new TreeSet<String>();
        for (AppLabelAtom label : this) {
            appNames.add(label.getApplication());
        }
        return appNames;
    }

    public Set<String> getAppVersions(String appName) {
        TreeSet<String> appVersions = new TreeSet<String>();
        for (AppLabelAtom label : this) {
            if (!appName.equals(label.getApplication())) continue;
            appVersions.add(label.getVersion());
        }
        return appVersions;
    }

    public List<String> getSortedAppVersions(String appName) {
        ArrayList<String> versionList = new ArrayList<String>(this.getAppVersions(appName));
        Collections.sort(versionList, new VersionComparator());
        Collections.reverse(versionList);
        return versionList;
    }

    public AppLabelAtom getApplicationLabel(String application, String version) {
        for (AppLabelAtom label : this) {
            if (!label.getApplication().equals(application) || !label.getVersion().equals(version)) continue;
            return label;
        }
        return null;
    }

    private static class VersionComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VersionComparator() {
        }

        @Override
        public int compare(String verString1, String verString2) {
            String[] verArray1 = verString1.split("\\.");
            String[] verArray2 = verString2.split("\\.");
            for (int i = 0; i < verArray1.length; ++i) {
                try {
                    try {
                        int num1 = Integer.parseInt(verArray1[i]);
                        int num2 = Integer.parseInt(verArray2[i]);
                        if (num1 == num2) continue;
                        return num1 - num2;
                    }
                    catch (NumberFormatException e) {
                        String num1 = verArray1[i];
                        String num2 = verArray2[i];
                        if (num1.equals(num2)) continue;
                        return num1.compareTo(num2);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return 1;
                }
            }
            return verArray1.length - verArray2.length;
        }
    }
}

