/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.ComboBoxModel;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.appdetector.AppLabelSet;
import org.jenkinsci.plugins.appdetector.Messages;
import org.jenkinsci.plugins.appdetector.util.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class AppDetectorParamaterDefinition
extends SimpleParameterDefinition {
    private final String appName;
    private List<String> choices;
    private final String defaultValue;

    public AppDetectorParamaterDefinition(String name, String appName, String description) {
        super(name, description);
        this.appName = appName;
        this.choices = this.getSortedVersionList();
        this.defaultValue = null;
    }

    @DataBoundConstructor
    public AppDetectorParamaterDefinition(String name, String appName, String defaultValue, String description) {
        super(name, description);
        this.appName = appName;
        this.choices = this.getSortedVersionList();
        this.defaultValue = defaultValue;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof StringParameterValue) {
            StringParameterValue value = (StringParameterValue)defaultValue;
            return new AppDetectorParamaterDefinition(this.getName(), this.getAppName(), value.value, this.getDescription());
        }
        return this;
    }

    @Exported
    public String getAppName() {
        return this.appName;
    }

    @Exported
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getSortedVersionList() {
        return Utils.getApplicationLabels().getSortedAppVersions(this.appName);
    }

    public StringParameterValue getDefaultParameterValue() {
        this.choices = new ArrayList<String>(Utils.getApplicationLabels().getSortedAppVersions(this.appName));
        if (this.choices.contains(this.defaultValue)) {
            return new StringParameterValue(this.getName(), this.defaultValue, this.getDescription());
        }
        return new StringParameterValue(this.getName(), this.choices.get(0), this.getDescription());
    }

    private StringParameterValue checkValue(StringParameterValue value) {
        this.choices = new ArrayList<String>(Utils.getApplicationLabels().getSortedAppVersions(this.appName));
        if (!this.choices.contains(value.value)) {
            throw new IllegalArgumentException("Illegal choice for parameter " + this.getName() + ": " + value.value);
        }
        return value;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return this.checkValue(value);
    }

    public StringParameterValue createValue(String value) {
        return this.checkValue(new StringParameterValue(this.getName(), value, this.getDescription()));
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.AppDetectorParamaterDefinition_DisplayName();
        }

        public ListBoxModel doFillAppNameItems() {
            ListBoxModel items = new ListBoxModel();
            AppLabelSet labels = Utils.getApplicationLabels();
            for (String appName : labels.getAppNames()) {
                items.add(appName);
            }
            return items;
        }

        public ComboBoxModel doFillDefaultValueItems(@QueryParameter(value="appName") String appName) {
            AppLabelSet labels = Utils.getApplicationLabels();
            return new ComboBoxModel(labels.getSortedAppVersions(appName));
        }
    }
}

