/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.LabelFinder;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.appdetector.AppDetectionSetting;
import org.jenkinsci.plugins.appdetector.AppDetectorBuildWrapper;
import org.jenkinsci.plugins.appdetector.AppLabelAtom;
import org.jenkinsci.plugins.appdetector.Messages;
import org.jenkinsci.plugins.appdetector.task.AppDetectionTask;

@Extension
public class AppDetectorLabelFinder
extends LabelFinder {
    private final Map<Node, Set<LabelAtom>> cashedLabels = new ConcurrentHashMap<Node, Set<LabelAtom>>();

    public Collection<LabelAtom> findLabels(Node node) {
        Computer computer = node.toComputer();
        if (computer == null || node.getChannel() == null) {
            return Collections.emptyList();
        }
        Set<LabelAtom> applications = this.cashedLabels.get(node);
        if (applications == null || applications.isEmpty()) {
            return Collections.emptyList();
        }
        return applications;
    }

    @Extension
    public static class AppDetectorComputerListener
    extends ComputerListener {
        public void onOnline(Computer computer, TaskListener taskListener) {
            Set<LabelAtom> applications = this.detectInstalledApplications(computer);
            if (!applications.isEmpty()) {
                this.finder().cashedLabels.put(computer.getNode(), applications);
            } else {
                this.finder().cashedLabels.remove(computer.getNode());
            }
        }

        public void onConfigurationChange() {
            AppDetectorLabelFinder finder = this.finder();
            HashSet cachedNodes = new HashSet(finder.cashedLabels.keySet());
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return;
            }
            List realNodes = jenkins.getNodes();
            for (Node node : cachedNodes) {
                if (realNodes.contains(node)) continue;
                finder.cashedLabels.remove(node);
            }
        }

        private AppDetectorLabelFinder finder() {
            return (AppDetectorLabelFinder)((Object)LabelFinder.all().get(AppDetectorLabelFinder.class));
        }

        private Set<LabelAtom> detectInstalledApplications(Computer computer) {
            Logger logger = LogManager.getLogManager().getLogger("hudson.WebAppMain");
            HashSet<LabelAtom> applications = new HashSet<LabelAtom>();
            Jenkins hudsonInstance = Jenkins.getInstance();
            if (hudsonInstance == null) {
                logger.warning(Messages.CANNOT_GET_HUDSON_INSTANCE());
                return applications;
            }
            AppDetectorBuildWrapper.DescriptorImpl descriptor = (AppDetectorBuildWrapper.DescriptorImpl)hudsonInstance.getDescriptorByType(AppDetectorBuildWrapper.DescriptorImpl.class);
            Boolean isUnix = computer.isUnix();
            if (isUnix == null) {
                return applications;
            }
            for (AppDetectionSetting setting : descriptor.getDetectionSettings()) {
                try {
                    AppDetectionTask task = new AppDetectionTask(setting);
                    String result = (String)computer.getChannel().call((Callable)task);
                    JSONArray appVersions = JSONArray.fromObject((Object)result);
                    for (Object appInfo : appVersions) {
                        JSONObject info = JSONObject.fromObject(appInfo);
                        applications.add(new AppLabelAtom(setting.getAppName(), info.getString("version"), info.getString("home")));
                    }
                }
                catch (Exception e) {
                    logger.warning(Messages.DETECTING_SOFTOWARE_INSTLLATION_FAILED(setting.getAppName(), computer.getDisplayName()));
                    e.printStackTrace();
                }
            }
            return applications;
        }
    }
}

