/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector;

import hudson.Extension;
import hudson.matrix.Combination;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Action;
import hudson.model.Label;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.appdetector.AppDetectorBuildWrapper;
import org.jenkinsci.plugins.appdetector.AppUsageSetting;
import org.jenkinsci.plugins.appdetector.util.Utils;

@Extension(ordinal=-100.0)
public class AppDetectorHandler
extends Queue.QueueDecisionHandler {
    public boolean shouldSchedule(Queue.Task task, List<Action> actions) {
        if (task instanceof Project) {
            DescribableList buildWapperList = ((Project)task).getBuildWrappersList();
            for (BuildWrapper bw : buildWapperList) {
                if (!(bw instanceof AppDetectorBuildWrapper)) continue;
                List<AppUsageSetting> settings = ((AppDetectorBuildWrapper)bw).getAppUsageSettings();
                if (settings.isEmpty()) {
                    return true;
                }
                TreeMap<String, String> buildVars = new TreeMap<String, String>();
                if (task instanceof MatrixConfiguration) {
                    Combination combination = ((MatrixConfiguration)task).getCombination();
                    buildVars.putAll((Map<String, String>)combination);
                }
                buildVars.putAll(this.getBuildVariablesFromActions(actions));
                ApplicationLabelAssignmentAction action = new ApplicationLabelAssignmentAction();
                for (AppUsageSetting setting : settings) {
                    String expandedVersion = Utils.expandVariables(buildVars, setting.getVersion());
                    action.add(setting.getAppName() + "-" + expandedVersion);
                }
                actions.add((Action)action);
            }
        }
        return true;
    }

    private Map<String, String> getBuildVariablesFromActions(List<Action> actions) {
        HashMap<String, String> buildVars = new HashMap<String, String>();
        for (Action action : actions) {
            if (!(action instanceof ParametersAction)) continue;
            for (ParameterValue param : ((ParametersAction)action).getParameters()) {
                if (param.getValue() == null) continue;
                buildVars.put(param.getName(), param.getValue().toString());
            }
        }
        return buildVars;
    }

    private static class ApplicationLabelAssignmentAction
    implements LabelAssignmentAction {
        private Label label = null;

        public Label getAssignedLabel(SubTask task) {
            Label taskLabel = task.getAssignedLabel();
            if (taskLabel != null) {
                return this.label.and(taskLabel);
            }
            return this.label;
        }

        public void add(String labelString) {
            this.label = this.label == null ? new LabelAtom(labelString) : this.label.and((Label)new LabelAtom(labelString));
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }
}

