/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.appdetector;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.remoting.Callable;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.appdetector.AppDetectionSetting;
import org.jenkinsci.plugins.appdetector.AppLabelAtom;
import org.jenkinsci.plugins.appdetector.AppLabelSet;
import org.jenkinsci.plugins.appdetector.AppUsageSetting;
import org.jenkinsci.plugins.appdetector.Messages;
import org.jenkinsci.plugins.appdetector.task.AppDetectionTask;
import org.jenkinsci.plugins.appdetector.util.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class AppDetectorBuildWrapper
extends BuildWrapper {
    private List<AppUsageSetting> usageSettings;

    public AppDetectorBuildWrapper() {
    }

    @DataBoundConstructor
    public AppDetectorBuildWrapper(List<AppUsageSetting> usageSettings) {
        this.usageSettings = usageSettings;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        Map buildVars = build.getBuildVariables();
        Node node = build.getBuiltOn();
        if (node == null) {
            logger.println(Messages.GETTING_NODE_FAILED());
            build.setResult(Result.FAILURE);
            return null;
        }
        AppLabelSet allLabels = Utils.getApplicationLabels(node);
        final ArrayList<AppLabelAtom> labels = new ArrayList<AppLabelAtom>();
        for (AppUsageSetting setting : this.usageSettings) {
            String expandedVersion = Utils.expandVariables(buildVars, setting.getVersion());
            AppLabelAtom label = allLabels.getApplicationLabel(setting.getAppName(), expandedVersion);
            if (label == null) {
                logger.println(Messages.APP_NOT_FOUND(setting.getAppName(), expandedVersion, node.getNodeName()));
                build.setResult(Result.NOT_BUILT);
                return null;
            }
            labels.add(label);
        }
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                Jenkins hudsonInstance = Jenkins.getInstance();
                if (hudsonInstance != null) {
                    DescriptorImpl descriptor = (DescriptorImpl)hudsonInstance.getDescriptorByType(DescriptorImpl.class);
                    List<AppDetectionSetting> detectionSettings = descriptor.getDetectionSettings();
                    for (AppLabelAtom label : labels) {
                        String envVarName = null;
                        for (AppDetectionSetting setting : detectionSettings) {
                            if (!label.getApplication().equals(setting.getAppName())) continue;
                            envVarName = setting.getHomeDirVarName();
                            break;
                        }
                        if (envVarName == null || "".equals(envVarName)) continue;
                        env.put(envVarName, label.getHome());
                    }
                }
            }
        };
    }

    public List<AppUsageSetting> getAppUsageSettings() {
        return this.usageSettings;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private List<AppDetectionSetting> detectionSettings = new ArrayList<AppDetectionSetting>();

        public DescriptorImpl() {
            super(AppDetectorBuildWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.JOB_DESCRIPTION();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.detectionSettings = new ArrayList<AppDetectionSetting>();
            JSONArray settingArray = json.optJSONArray("setting");
            if (settingArray != null) {
                for (Object settingObj : settingArray) {
                    JSONObject setting = JSONObject.fromObject(settingObj);
                    this.detectionSettings.add(new AppDetectionSetting(setting.getString("appName"), setting.getString("script"), setting.getBoolean("detectOnLinux"), setting.getBoolean("detectOnOsx"), setting.getBoolean("detectOnWindows"), setting.getString("homeDirVarName")));
                }
            } else {
                JSONObject setting = json.optJSONObject("setting");
                if (setting != null) {
                    this.detectionSettings.add(new AppDetectionSetting(setting.getString("appName"), setting.getString("script"), setting.getBoolean("detectOnLinux"), setting.getBoolean("detectOnOsx"), setting.getBoolean("detectOnWindows"), setting.getString("homeDirVarName")));
                }
            }
            this.save();
            return true;
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            ArrayList<AppUsageSetting> usageSettings = new ArrayList<AppUsageSetting>();
            JSONArray settingArray = json.optJSONArray("setting");
            if (settingArray != null) {
                for (Object settingObj : settingArray) {
                    JSONObject setting = JSONObject.fromObject(settingObj);
                    usageSettings.add(new AppUsageSetting(setting.getString("appName"), setting.getString("appVersion")));
                }
            } else {
                JSONObject setting = json.optJSONObject("setting");
                if (setting != null) {
                    usageSettings.add(new AppUsageSetting(setting.getString("appName"), setting.getString("appVersion")));
                }
            }
            return new AppDetectorBuildWrapper(usageSettings);
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public ListBoxModel doFillAppNameItems() {
            ListBoxModel items = new ListBoxModel();
            AppLabelSet labels = Utils.getApplicationLabels();
            for (String appName : labels.getAppNames()) {
                items.add(appName);
            }
            return items;
        }

        public ComboBoxModel doFillAppVersionItems(@QueryParameter(value="appName") String appName) {
            AppLabelSet labels = Utils.getApplicationLabels();
            return new ComboBoxModel(labels.getSortedAppVersions(appName));
        }

        public ListBoxModel doFillNodeItems() {
            Computer[] allComputers;
            ListBoxModel items = new ListBoxModel();
            for (Computer computer : allComputers = Utils.getAllComputers()) {
                if (computer.isOnline()) {
                    items.add(computer.getDisplayName(), computer.getName());
                    continue;
                }
                items.add(computer.getDisplayName() + "(offline)", computer.getName());
            }
            return items;
        }

        @RequirePOST
        public FormValidation doTestScript(@QueryParameter(value="script") String script, @QueryParameter(value="node") String node, @QueryParameter(value="detectOnLinux") boolean onLinux, @QueryParameter(value="detectOnOsx") boolean onOsx, @QueryParameter(value="detectOnWindows") boolean onWindows) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.error((String)Messages.CANNOT_GET_HUDSON_INSTANCE());
            }
            jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
            AppDetectionSetting setting = new AppDetectionSetting("Test", script, onLinux, onOsx, onWindows, "TEST");
            try {
                Computer computer = jenkins.getComputer(node);
                String result = (String)computer.getChannel().call((Callable)new AppDetectionTask(setting));
                return FormValidation.ok((String)result);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
        }

        public List<AppDetectionSetting> getDetectionSettings() {
            return this.detectionSettings;
        }
    }
}

