// CHECKSTYLE:OFF

package hudson.tasks._ant;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Maybe you need to configure the job to choose one of your Ant installations?
     * 
     */
    public static String Ant_ProjectConfigNeeded() {
        return holder.format("Ant.ProjectConfigNeeded");
    }

    /**
     * Maybe you need to configure the job to choose one of your Ant installations?
     * 
     */
    public static Localizable _Ant_ProjectConfigNeeded() {
        return new Localizable(holder, "Ant.ProjectConfigNeeded");
    }

    /**
     * Cannot find executable from the chosen Ant installation "{0}"
     * 
     */
    public static String Ant_ExecutableNotFound(Object arg1) {
        return holder.format("Ant.ExecutableNotFound", arg1);
    }

    /**
     * Cannot find executable from the chosen Ant installation "{0}"
     * 
     */
    public static Localizable _Ant_ExecutableNotFound(Object arg1) {
        return new Localizable(holder, "Ant.ExecutableNotFound", arg1);
    }

    /**
     * Install from Apache
     * 
     */
    public static String InstallFromApache() {
        return holder.format("InstallFromApache");
    }

    /**
     * Install from Apache
     * 
     */
    public static Localizable _InstallFromApache() {
        return new Localizable(holder, "InstallFromApache");
    }

    /**
     * {0} is not a directory
     * 
     */
    public static String Ant_NotADirectory(Object arg1) {
        return holder.format("Ant.NotADirectory", arg1);
    }

    /**
     * {0} is not a directory
     * 
     */
    public static Localizable _Ant_NotADirectory(Object arg1) {
        return new Localizable(holder, "Ant.NotADirectory", arg1);
    }

    /**
     * command execution failed.
     * 
     */
    public static String Ant_ExecFailed() {
        return holder.format("Ant.ExecFailed");
    }

    /**
     * command execution failed.
     * 
     */
    public static Localizable _Ant_ExecFailed() {
        return new Localizable(holder, "Ant.ExecFailed");
    }

    /**
     * Maybe you need to configure where your Ant installations are?
     * 
     */
    public static String Ant_GlobalConfigNeeded() {
        return holder.format("Ant.GlobalConfigNeeded");
    }

    /**
     * Maybe you need to configure where your Ant installations are?
     * 
     */
    public static Localizable _Ant_GlobalConfigNeeded() {
        return new Localizable(holder, "Ant.GlobalConfigNeeded");
    }

    /**
     * {0} doesn''t look like an Ant directory
     * 
     */
    public static String Ant_NotAntDirectory(Object arg1) {
        return holder.format("Ant.NotAntDirectory", arg1);
    }

    /**
     * {0} doesn''t look like an Ant directory
     * 
     */
    public static Localizable _Ant_NotAntDirectory(Object arg1) {
        return new Localizable(holder, "Ant.NotAntDirectory", arg1);
    }

    /**
     * Invoke Ant
     * 
     */
    public static String Ant_DisplayName() {
        return holder.format("Ant.DisplayName");
    }

    /**
     * Invoke Ant
     * 
     */
    public static Localizable _Ant_DisplayName() {
        return new Localizable(holder, "Ant.DisplayName");
    }

}
