/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import hudson.Extension;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.androidsigning.SignApksBuilder;

@Extension
public class MultiEntryToSingleEntryBuilderMigration
extends ItemListener {
    private static final Logger log = Logger.getLogger(MultiEntryToSingleEntryBuilderMigration.class.getName());

    public void onLoaded() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            log.warning("jenkins instance is null; cannot migrate old job data");
            return;
        }
        List jobs = jenkins.getAllItems(Project.class);
        for (Project job : jobs) {
            this.migrateBuildersOfJob(job);
        }
    }

    private void migrateBuildersOfJob(Project<?, ?> job) {
        DescribableList old = job.getBuildersList();
        boolean isMigrated = old.stream().allMatch(builder -> {
            if (builder instanceof SignApksBuilder) {
                return ((SignApksBuilder)((Object)builder)).isMigrated();
            }
            return true;
        });
        if (isMigrated) {
            return;
        }
        ArrayList<Builder> migrated = new ArrayList<Builder>();
        for (Builder builder2 : old) {
            if (builder2 instanceof SignApksBuilder) {
                migrated.addAll(SignApksBuilder.singleEntryBuildersFromEntriesOfBuilder((SignApksBuilder)builder2));
                continue;
            }
            migrated.add(builder2);
        }
        try {
            job.getBuildersList().replaceBy(migrated);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "error migrating " + SignApksBuilder.class.getSimpleName() + " steps of job " + job, e);
        }
    }
}

