/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ActiveDirectoryDomain
extends AbstractDescribableImpl<ActiveDirectoryDomain>
implements Serializable {
    public String name;
    public String servers;
    public String site;
    public String bindName;
    public Secret bindPassword;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());

    public ActiveDirectoryDomain(String name, String servers) {
        this(name, servers, null, null, null);
    }

    @DataBoundConstructor
    public ActiveDirectoryDomain(String name, String servers, String site, String bindName, String bindPassword) {
        this.name = name;
        servers = ActiveDirectoryDomain.fixEmpty(servers);
        if (servers != null) {
            Object[] serversArray = servers.split(",");
            for (int i = 0; i < serversArray.length; ++i) {
                if (serversArray[i].contains(":")) continue;
                int n = i;
                serversArray[n] = (String)serversArray[n] + ":3268";
            }
            servers = StringUtils.join((Object[])serversArray, (String)",");
        }
        this.servers = servers;
        this.site = ActiveDirectoryDomain.fixEmpty(site);
        this.bindName = ActiveDirectoryDomain.fixEmpty(bindName);
        this.bindPassword = Secret.fromString((String)ActiveDirectoryDomain.fixEmpty(bindPassword));
    }

    @Restricted(value={NoExternalUse.class})
    public String getName() {
        return this.name;
    }

    @Restricted(value={NoExternalUse.class})
    public String getServers() {
        return this.servers;
    }

    @Restricted(value={NoExternalUse.class})
    public String getBindName() {
        return this.bindName;
    }

    @Restricted(value={NoExternalUse.class})
    public Secret getBindPassword() {
        return this.bindPassword;
    }

    @Restricted(value={NoExternalUse.class})
    public String getSite() {
        return this.site;
    }

    public static String fixEmpty(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ActiveDirectoryDomain> {
        public String getDisplayName() {
            return "";
        }

        /*
         * Exception decompiling
         */
        public FormValidation doValidateTest(@QueryParameter(fixEmpty=true) String name, @QueryParameter(fixEmpty=true) String servers, @QueryParameter(fixEmpty=true) String site, @QueryParameter(fixEmpty=true) String bindName, @QueryParameter(fixEmpty=true) String bindPassword) throws IOException, ServletException, NamingException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

