/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.CacheKey;
import java.util.concurrent.TimeUnit;
import org.acegisecurity.userdetails.UserDetails;
import org.kohsuke.stapler.DataBoundConstructor;

public class CacheConfiguration<K, V, E extends Exception> {
    private final int size;
    private final int ttl;
    private final transient Cache<CacheKey, UserDetails> userCache;
    private final transient Cache<String, ActiveDirectoryGroupDetails> groupCache;

    @DataBoundConstructor
    public CacheConfiguration(int size, int ttl) {
        this.size = Math.max(0, Math.min(size, 1000));
        this.ttl = Math.max(0, Math.min(ttl, 3600));
        this.userCache = Caffeine.newBuilder().maximumSize((long)this.getSize()).expireAfterWrite((long)this.getTtl(), TimeUnit.SECONDS).build();
        this.groupCache = Caffeine.newBuilder().maximumSize((long)this.getSize()).expireAfterWrite((long)this.getTtl(), TimeUnit.SECONDS).build();
    }

    public int getSize() {
        return this.size;
    }

    public int getTtl() {
        return this.ttl;
    }

    public Cache<CacheKey, UserDetails> getUserCache() {
        return this.userCache;
    }

    public Cache<String, ActiveDirectoryGroupDetails> getGroupCache() {
        return this.groupCache;
    }
}

