/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserAttributesHelper {
    private static final String ATTR_USER_ACCOUNT_CONTROL = "userAccountControl";
    private static final String ATTR_ACCOUNT_EXPIRES = "accountExpires";
    private static final String ATTR_USER_ACCOUNT_CONTROL_COMPUTED = "msDS-User-Account-Control-Computed";
    private static final String ATTR_USER_ACCOUNT_DISABLED = "msDS-UserAccountDisabled";
    private static final String ATTR_USER_PASSWORD_EXPIRED = "msDS-UserPasswordExpired";
    private static final long ACCOUNT_NO_EXPIRATION = Long.MAX_VALUE;
    private static final int ADS_UF_DISABLED = 2;
    private static final int ADS_UF_LOCK_OUT = 16;
    private static final int ADS_UF_PASSWORD_EXPIRED = 0x800000;

    public static boolean checkIfUserIsEnabled(@Nonnull Attributes user) {
        try {
            int uacAsInt;
            String userAccountControl = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL);
            if (userAccountControl != null && ((uacAsInt = Integer.parseInt(userAccountControl)) & 2) == 2) {
                return false;
            }
            String adamUserAccountDisabled = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_DISABLED);
            if (adamUserAccountDisabled != null) {
                return !adamUserAccountDisabled.equals("true");
            }
            return true;
        }
        catch (NamingException e) {
            return true;
        }
    }

    public static boolean checkIfAccountNonExpired(@Nonnull Attributes user) {
        try {
            String accountExpirationDate = UserAttributesHelper.getStringAttribute(user, ATTR_ACCOUNT_EXPIRES);
            if (accountExpirationDate != null) {
                long expirationAsLong = Long.parseLong(accountExpirationDate);
                if (expirationAsLong == 0L || expirationAsLong == Long.MAX_VALUE) {
                    return true;
                }
                long nowIn100NsFromJan1601 = UserAttributesHelper.getWin32EpochHundredNanos();
                boolean expired = expirationAsLong < nowIn100NsFromJan1601;
                return !expired;
            }
            return true;
        }
        catch (NamingException e) {
            return true;
        }
    }

    private static long getWin32EpochHundredNanos() {
        GregorianCalendar win32Epoch = new GregorianCalendar(1601, 0, 1);
        Date win32EpochDate = win32Epoch.getTime();
        GregorianCalendar today = new GregorianCalendar();
        Date todayDate = today.getTime();
        long timeSinceWin32EpochInMs = todayDate.getTime() - win32EpochDate.getTime();
        long timeSinceWin32EpochInNs = TimeUnit.NANOSECONDS.convert(timeSinceWin32EpochInMs, TimeUnit.MILLISECONDS);
        return timeSinceWin32EpochInNs * 100L;
    }

    public static boolean checkIfCredentialsAreNonExpired(@Nonnull Attributes user) {
        try {
            int uacAsInt;
            int uacAsInt2;
            String userAccountControl = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL);
            if (userAccountControl != null && ((uacAsInt2 = Integer.parseInt(userAccountControl)) & 0x800000) == 0x800000) {
                return false;
            }
            String userAccountControlComputed = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL_COMPUTED);
            if (userAccountControlComputed != null && ((uacAsInt = Integer.parseInt(userAccountControlComputed)) & 0x800000) == 0x800000) {
                return false;
            }
            String adamUserPasswordExpired = UserAttributesHelper.getStringAttribute(user, ATTR_USER_PASSWORD_EXPIRED);
            if (adamUserPasswordExpired != null) {
                return !adamUserPasswordExpired.equals("true");
            }
            return true;
        }
        catch (NamingException e) {
            return true;
        }
    }

    public static boolean checkIfAccountNonLocked(@Nonnull Attributes user) {
        try {
            int uacAsInt;
            int uacAsInt2;
            String userAccountControl = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL);
            if (userAccountControl != null && ((uacAsInt2 = Integer.parseInt(userAccountControl)) & 0x10) == 16) {
                return false;
            }
            String userAccountControlComputed = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL_COMPUTED);
            return userAccountControlComputed == null || ((uacAsInt = Integer.parseInt(userAccountControlComputed)) & 0x10) != 16;
        }
        catch (NamingException e) {
            return true;
        }
    }

    @CheckForNull
    private static String getStringAttribute(@Nonnull Attributes user, @Nonnull String name) throws NamingException {
        Attribute a = user.get(name);
        if (a == null) {
            return null;
        }
        Object v = a.get();
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

