/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ActiveDirectoryDomain
extends AbstractDescribableImpl<ActiveDirectoryDomain>
implements Serializable {
    public String name;
    public String servers;

    @DataBoundConstructor
    public ActiveDirectoryDomain(String name, String servers) {
        this.name = name;
        servers = ActiveDirectoryDomain.fixEmpty(servers);
        if (servers != null) {
            Object[] serversArray = servers.split(",");
            for (int i = 0; i < serversArray.length; ++i) {
                if (serversArray[i].contains(":")) continue;
                int n = i;
                serversArray[n] = (String)serversArray[n] + ":3268";
            }
            servers = StringUtils.join((Object[])serversArray, (String)",");
        }
        this.servers = servers;
    }

    @Restricted(value={NoExternalUse.class})
    public String getName() {
        return this.name;
    }

    @Restricted(value={NoExternalUse.class})
    public String getServers() {
        return this.servers;
    }

    public static String fixEmpty(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ActiveDirectoryDomain> {
        public String getDisplayName() {
            return "";
        }
    }
}

