/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComObjectListener;
import com4j.ExecutionException;
import com4j.Variant;
import com4j.typelibs.activeDirectory.IADs;
import com4j.typelibs.activeDirectory.IADsGroup;
import com4j.typelibs.activeDirectory.IADsOpenDSObject;
import com4j.typelibs.activeDirectory.IADsUser;
import com4j.typelibs.ado20.ClassFactory;
import com4j.typelibs.ado20._Command;
import com4j.typelibs.ado20._Connection;
import com4j.typelibs.ado20._Recordset;
import com4j.util.ComObjectCollector;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.CacheAuthenticationException;
import hudson.plugins.active_directory.CacheConfiguration;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.framework.io.IOException2;

public class ActiveDirectoryAuthenticationProvider
extends AbstractActiveDirectoryAuthenticationProvider {
    private final String defaultNamingContext;
    private final _Connection con;
    private CacheConfiguration cache;
    private final Cache<String, UserDetails> userCache;
    private final Cache<String, ActiveDirectoryGroupDetails> groupCache;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryAuthenticationProvider.class.getName());
    private static final int ADS_READONLY_SERVER = 4;

    public ActiveDirectoryAuthenticationProvider() throws IOException {
        this(null);
    }

    public ActiveDirectoryAuthenticationProvider(ActiveDirectorySecurityRealm realm) throws IOException {
        try {
            IADs rootDSE = (IADs)COM4J.getObject(IADs.class, (String)"LDAP://RootDSE", null);
            this.defaultNamingContext = (String)rootDSE.get("defaultNamingContext");
            LOGGER.info("Active Directory domain is " + this.defaultNamingContext);
            this.con = ClassFactory.createConnection();
            this.con.provider("ADsDSOObject");
            this.con.open("Active Directory Provider", "", "", -1);
            if (realm != null) {
                this.cache = realm.cache;
            }
            if (this.cache == null) {
                this.cache = new CacheConfiguration(0, 0);
            }
            if (this.cache.getUserCache() == null || this.cache.getGroupCache() == null) {
                this.cache = new CacheConfiguration(this.cache.getSize(), this.cache.getTtl());
            }
            this.userCache = this.cache.getUserCache();
            this.groupCache = this.cache.getGroupCache();
        }
        catch (ExecutionException e) {
            throw new IOException2("Failed to connect to Active Directory. Does this machine belong to Active Directory?", (Throwable)e);
        }
    }

    static String dnToLdapUrl(String dn) {
        return "LDAP://" + dn.replace("/", "\\/");
    }

    protected UserDetails retrieveUser(final String username, final UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            return (UserDetails)this.userCache.get((Object)username, (Callable)new Callable<UserDetails>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public UserDetails call() {
                    String password = null;
                    if (authentication != null) {
                        password = (String)authentication.getCredentials();
                    }
                    String dn = ActiveDirectoryAuthenticationProvider.this.getDnOfUserOrGroup(username);
                    ComObjectCollector col = new ComObjectCollector();
                    COM4J.addListener((ComObjectListener)col);
                    try {
                        IADsUser usr;
                        IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
                        try {
                            usr = (IADsUser)(authentication == null ? dso.openDSObject(ActiveDirectoryAuthenticationProvider.dnToLdapUrl(dn), null, null, 4) : dso.openDSObject(ActiveDirectoryAuthenticationProvider.dnToLdapUrl(dn), dn, password, 4)).queryInterface(IADsUser.class);
                        }
                        catch (ComException e) {
                            String msg = String.format("Incorrect password for %s DN=%s: error=%08X", username, dn, e.getHRESULT());
                            LOGGER.log(Level.FINE, String.format("Login failure: Incorrect password for %s DN=%s: error=%08X", username, dn, e.getHRESULT()), e);
                            throw (BadCredentialsException)new BadCredentialsException(msg).initCause((Throwable)e);
                        }
                        if (usr == null) {
                            throw new UsernameNotFoundException("User not found: " + username);
                        }
                        ArrayList<Object> groups = new ArrayList<Object>();
                        for (Com4jObject g : usr.groups()) {
                            if (g == null) continue;
                            IADsGroup grp = (IADsGroup)g.queryInterface(IADsGroup.class);
                            groups.add(new GrantedAuthorityImpl(grp.name().substring(3)));
                        }
                        groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                        LOGGER.log(Level.FINE, "Login successful: {0} dn={1}", new Object[]{username, dn});
                        UserDetails userDetails = new ActiveDirectoryUserDetail(username, password, !ActiveDirectoryAuthenticationProvider.this.isAccountDisabled(usr), true, true, true, groups.toArray(new GrantedAuthority[groups.size()]), ActiveDirectoryAuthenticationProvider.this.getFullName(usr), ActiveDirectoryAuthenticationProvider.this.getEmailAddress(usr), ActiveDirectoryAuthenticationProvider.this.getTelephoneNumber(usr)).updateUserInfo();
                        return userDetails;
                    }
                    finally {
                        col.disposeAll();
                        COM4J.removeListener((ComObjectListener)col);
                    }
                }
            });
        }
        catch (UncheckedExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof AuthenticationException) {
                AuthenticationException authenticationException = (AuthenticationException)t;
                throw authenticationException;
            }
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching user " + username, (Exception)((Object)e));
        }
        catch (java.util.concurrent.ExecutionException e) {
            LOGGER.log(Level.SEVERE, String.format("There was a problem caching user %s", username), e);
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching user " + username, e);
        }
    }

    protected boolean canRetrieveUserByName() {
        return true;
    }

    private String getTelephoneNumber(IADsUser usr) {
        try {
            Object t = usr.telephoneNumber();
            return t == null ? null : t.toString();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private String getEmailAddress(IADsUser usr) {
        try {
            return usr.emailAddress();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private String getFullName(IADsUser usr) {
        try {
            return usr.fullName();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private boolean isAccountDisabled(IADsUser usr) {
        try {
            return usr.accountDisabled();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return false;
            }
            throw e;
        }
    }

    private String getDnOfUserOrGroup(String userOrGroupname) throws UsernameNotFoundException {
        _Command cmd = ClassFactory.createCommand();
        cmd.activeConnection(this.con);
        cmd.commandText("<LDAP://" + this.defaultNamingContext + ">;(sAMAccountName=" + userOrGroupname + ");distinguishedName;subTree");
        _Recordset rs = cmd.execute(null, (Object)Variant.getMissing(), -1);
        if (rs.eof()) {
            throw new UsernameNotFoundException("No such user or group: " + userOrGroupname);
        }
        String dn = rs.fields().item((Object)"distinguishedName").value().toString();
        return dn;
    }

    public GroupDetails loadGroupByGroupname(final String groupname) {
        try {
            return (GroupDetails)this.groupCache.get((Object)groupname, (Callable)new Callable<ActiveDirectoryGroupDetails>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ActiveDirectoryGroupDetails call() throws Exception {
                    ActiveDirectoryGroupDetails activeDirectoryGroupDetails;
                    ComObjectCollector col = new ComObjectCollector();
                    COM4J.addListener((ComObjectListener)col);
                    try {
                        String dn = ActiveDirectoryAuthenticationProvider.this.getDnOfUserOrGroup(groupname);
                        IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
                        IADsGroup group = (IADsGroup)dso.openDSObject(ActiveDirectoryAuthenticationProvider.dnToLdapUrl(dn), null, null, 4).queryInterface(IADsGroup.class);
                        if (group == null) {
                            ActiveDirectoryGroupDetails activeDirectoryGroupDetails2 = null;
                            return activeDirectoryGroupDetails2;
                        }
                        ActiveDirectoryGroupDetails activeDirectoryGroupDetails3 = new ActiveDirectoryGroupDetails(groupname);
                        return activeDirectoryGroupDetails3;
                    }
                    catch (UsernameNotFoundException e) {
                        activeDirectoryGroupDetails = null;
                        return activeDirectoryGroupDetails;
                    }
                    catch (ComException e) {
                        LOGGER.log(Level.WARNING, String.format("Failed to figure out details of AD group: %s", groupname), e);
                        activeDirectoryGroupDetails = null;
                        return activeDirectoryGroupDetails;
                    }
                    finally {
                        col.disposeAll();
                        COM4J.removeListener((ComObjectListener)col);
                    }
                }
            });
        }
        catch (UncheckedExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof AuthenticationException) {
                AuthenticationException authenticationException = (AuthenticationException)t;
                throw authenticationException;
            }
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching group " + groupname, (Exception)((Object)e));
        }
        catch (java.util.concurrent.ExecutionException e) {
            LOGGER.log(Level.SEVERE, String.format("There was a problem caching group %s", groupname), e);
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching group " + groupname, e);
        }
    }
}

